/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal.filters;

import com.google.common.annotations.VisibleForTesting;
import io.appium.java_client.internal.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;

public class AppiumUserAgentFilter
implements Filter {
    public static final String VERSION_KEY = "appiumClient.version";
    private static final String USER_AGENT_PREFIX = "appium/";
    public static final String USER_AGENT = AppiumUserAgentFilter.buildUserAgentHeaderValue(AddSeleniumUserAgent.USER_AGENT);

    private static String buildUserAgentHeaderValue(@Nonnull String previousUA) {
        return String.format("%s%s (%s)", USER_AGENT_PREFIX, Config.main().getValue(VERSION_KEY, String.class), previousUA);
    }

    @VisibleForTesting
    public static boolean containsAppiumName(@Nullable String userAgent) {
        return userAgent != null && userAgent.toLowerCase().contains(USER_AGENT_PREFIX.toLowerCase());
    }

    public static String buildUserAgent(@Nullable String userAgent) {
        if (userAgent == null) {
            return USER_AGENT;
        }
        if (AppiumUserAgentFilter.containsAppiumName(userAgent)) {
            return userAgent;
        }
        return AppiumUserAgentFilter.buildUserAgentHeaderValue(userAgent);
    }

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            req.setHeader("User-Agent", AppiumUserAgentFilter.buildUserAgent(req.getHeader("User-Agent")));
            return next.execute(req);
        };
    }
}

