/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Throwables;
import io.appium.java_client.AppiumClientConfig;
import io.appium.java_client.internal.ReflectionHelpers;
import io.appium.java_client.remote.AppiumProtocolHandshake;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import io.appium.java_client.remote.DirectConnect;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final Optional<DriverService> serviceOptional;
    private final HttpClient.Factory httpClientFactory;
    private final AppiumClientConfig appiumClientConfig;

    public AppiumCommandExecutor(@Nonnull Map<String, CommandInfo> additionalCommands, @Nullable DriverService service, @Nullable HttpClient.Factory httpClientFactory, @Nonnull AppiumClientConfig appiumClientConfig) {
        super(additionalCommands, (ClientConfig)appiumClientConfig, Optional.ofNullable(httpClientFactory).orElseGet(HttpCommandExecutor::getDefaultClientFactory));
        this.serviceOptional = Optional.ofNullable(service);
        this.httpClientFactory = httpClientFactory;
        this.appiumClientConfig = appiumClientConfig;
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, Objects.requireNonNull(service), httpClientFactory, AppiumClientConfig.defaultConfig().baseUrl(Objects.requireNonNull(service).getUrl()));
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, httpClientFactory, AppiumClientConfig.defaultConfig().baseUrl(Objects.requireNonNull(addressOfRemoteServer)));
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, AppiumClientConfig appiumClientConfig) {
        this(additionalCommands, null, null, appiumClientConfig);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, null, HttpClient.Factory.createDefault(), AppiumClientConfig.defaultConfig().baseUrl(Objects.requireNonNull(addressOfRemoteServer)));
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, AppiumClientConfig appiumClientConfig) {
        this(additionalCommands, null, HttpClient.Factory.createDefault(), appiumClientConfig.baseUrl(Objects.requireNonNull(addressOfRemoteServer)));
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, HttpClient.Factory.createDefault(), AppiumClientConfig.defaultConfig().baseUrl(service.getUrl()));
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, AppiumClientConfig appiumClientConfig) {
        this(additionalCommands, service, HttpClient.Factory.createDefault(), appiumClientConfig);
    }

    protected <B> B getPrivateFieldValue(Class<? extends CommandExecutor> cls, String fieldName, Class<B> fieldType) {
        return ReflectionHelpers.getPrivateFieldValue(cls, (Object)this, fieldName, fieldType);
    }

    protected void setPrivateFieldValue(Class<? extends CommandExecutor> cls, String fieldName, Object newValue) {
        ReflectionHelpers.setPrivateFieldValue(cls, this, fieldName, newValue);
    }

    protected Map<String, CommandInfo> getAdditionalCommands() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "additionalCommands", Map.class);
    }

    protected CommandCodec<HttpRequest> getCommandCodec() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "commandCodec", CommandCodec.class);
    }

    public void setCommandCodec(CommandCodec<HttpRequest> newCodec) {
        this.setPrivateFieldValue(HttpCommandExecutor.class, "commandCodec", newCodec);
    }

    public void setResponseCodec(ResponseCodec<HttpResponse> codec) {
        this.setPrivateFieldValue(HttpCommandExecutor.class, "responseCodec", codec);
    }

    protected HttpClient getClient() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "client", HttpClient.class);
    }

    protected void overrideServerUrl(URL serverUrl) {
        if (this.appiumClientConfig == null) {
            return;
        }
        this.setPrivateFieldValue(HttpCommandExecutor.class, "client", Optional.ofNullable(this.httpClientFactory).orElseGet(HttpCommandExecutor::getDefaultClientFactory).createClient((ClientConfig)this.appiumClientConfig.baseUrl(serverUrl)));
    }

    private Response createSession(Command command) throws IOException {
        if (this.getCommandCodec() != null) {
            throw new SessionNotCreatedException("Session already exists");
        }
        ProtocolHandshake.Result result = new AppiumProtocolHandshake().createSession((HttpHandler)this.getClient(), command);
        Dialect dialect = result.getDialect();
        if (!(dialect.getCommandCodec() instanceof W3CHttpCommandCodec)) {
            throw new SessionNotCreatedException("Only W3C sessions are supported. Please make sure your server is up to date.");
        }
        this.setCommandCodec((CommandCodec<HttpRequest>)new AppiumW3CHttpCommandCodec());
        this.refreshAdditionalCommands();
        this.setResponseCodec((ResponseCodec<HttpResponse>)dialect.getResponseCodec());
        Response response = result.createResponse();
        if (this.appiumClientConfig != null && this.appiumClientConfig.isDirectConnectEnabled()) {
            this.setDirectConnect(response);
        }
        return response;
    }

    public void refreshAdditionalCommands() {
        this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((AppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
    }

    private void setDirectConnect(Response response) throws SessionNotCreatedException {
        URL newUrl;
        Map responseValue = (Map)response.getValue();
        DirectConnect directConnect = new DirectConnect(responseValue);
        if (!directConnect.isValid()) {
            return;
        }
        if (!directConnect.getProtocol().equals("https")) {
            throw new SessionNotCreatedException(String.format("The given protocol '%s' as the direct connection url returned by the remote server is not accurate. Only 'https' is supported.", directConnect.getProtocol()));
        }
        try {
            newUrl = directConnect.getUrl();
        }
        catch (MalformedURLException e) {
            throw new SessionNotCreatedException(e.getMessage());
        }
        this.overrideServerUrl(newUrl);
    }

    public Response execute(Command command) throws WebDriverException {
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), (Throwable)e);
                }
            });
        }
        try {
            Response response = "newSession".equals(command.getName()) ? this.createSession(command) : super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                throw this.serviceOptional.map(service -> {
                    if (service.isRunning()) {
                        return new WebDriverException("The session is closed!", rootCause);
                    }
                    return new WebDriverException("The appium server has accidentally died!", rootCause);
                }).orElseGet(() -> new WebDriverException(rootCause.getMessage(), rootCause));
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
    }
}

