/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.message.client.PreparedExecuteMessage;
import io.asyncer.r2dbc.mysql.message.client.PreparedTextQueryMessage;
import java.util.Arrays;

final class Binding {
    private static final MySqlParameter[] EMPTY_VALUES = new MySqlParameter[0];
    private final MySqlParameter[] values;

    Binding(int length) {
        this.values = length == 0 ? EMPTY_VALUES : new MySqlParameter[length];
    }

    void add(int index, MySqlParameter value) {
        if (index < 0 || index >= this.values.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", length: " + this.values.length);
        }
        this.values[index] = value;
    }

    PreparedExecuteMessage toExecuteMessage(int statementId, boolean immediate) {
        if (this.values.length == 0) {
            return new PreparedExecuteMessage(statementId, immediate, EMPTY_VALUES);
        }
        if (this.values[0] == null) {
            throw new IllegalStateException("Parameters has been used");
        }
        return new PreparedExecuteMessage(statementId, immediate, this.drainValues());
    }

    PreparedTextQueryMessage toTextMessage(Query query) {
        return new PreparedTextQueryMessage(query, this.drainValues());
    }

    void clear() {
        for (MySqlParameter value : this.values) {
            this.values[i] = null;
            if (value == null) continue;
            value.dispose();
        }
    }

    int findUnbind() {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (this.values[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)o;
        return Arrays.equals(this.values, binding.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return String.format("Binding{values=%s}", Arrays.toString(this.values));
    }

    private MySqlParameter[] drainValues() {
        MySqlParameter[] results = new MySqlParameter[this.values.length];
        System.arraycopy(this.values, 0, results, 0, this.values.length);
        Arrays.fill(this.values, null);
        return results;
    }
}

