/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlStatement;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import org.jetbrains.annotations.Nullable;

abstract class MySqlStatementSupport
implements MySqlStatement {
    private static final String LAST_INSERT_ID = "LAST_INSERT_ID";
    @Nullable
    String generatedKeyName = null;

    MySqlStatementSupport() {
    }

    @Override
    public final MySqlStatement returnGeneratedValues(String ... columns) {
        AssertUtils.requireNonNull(columns, "columns must not be null");
        switch (columns.length) {
            case 0: {
                this.generatedKeyName = LAST_INSERT_ID;
                return this;
            }
            case 1: {
                this.generatedKeyName = AssertUtils.requireValidName(columns[0], "id name must not be empty and not contain backticks");
                return this;
            }
        }
        throw new IllegalArgumentException("MySQL only supports single generated value");
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        return this;
    }
}

