/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.authentication;

import io.asyncer.r2dbc.mysql.authentication.AuthUtils;
import io.asyncer.r2dbc.mysql.authentication.MySqlAuthProvider;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.nio.CharBuffer;
import org.jetbrains.annotations.Nullable;

final class CachingSha2FullAuthProvider
implements MySqlAuthProvider {
    static final CachingSha2FullAuthProvider INSTANCE = new CachingSha2FullAuthProvider();

    @Override
    public boolean isSslNecessary() {
        return true;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, byte[] salt, CharCollation collation) {
        if (password == null || password.length() <= 0) {
            return new byte[]{0};
        }
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        return AuthUtils.encodeTerminal(CharBuffer.wrap(password), collation.getCharset());
    }

    @Override
    public MySqlAuthProvider next() {
        return this;
    }

    @Override
    public String getType() {
        return "caching_sha2_password";
    }

    private CachingSha2FullAuthProvider() {
    }
}

