/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import reactor.core.publisher.Mono;

final class ByteBufferCodec
extends AbstractClassedCodec<ByteBuffer> {
    ByteBufferCodec(ByteBufAllocator allocator) {
        super(allocator, ByteBuffer.class);
    }

    @Override
    public ByteBuffer decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return ByteBuffer.wrap(InternalArrays.EMPTY_BYTES);
        }
        ByteBuffer result = ByteBuffer.allocate(value.readableBytes());
        value.readBytes(result);
        result.flip();
        return result;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new ByteBufferMySqlParameter(this.allocator, (ByteBuffer)value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof ByteBuffer;
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isBinary();
    }

    private static final class ByteBufferMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final ByteBuffer buffer;

        private ByteBufferMySqlParameter(ByteBufAllocator allocator, ByteBuffer buffer) {
            this.allocator = allocator;
            this.buffer = buffer;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                if (!this.buffer.hasRemaining()) {
                    return this.allocator.buffer(1).writeByte(0);
                }
                int size = this.buffer.remaining();
                ByteBuf buf = this.allocator.buffer(VarIntUtils.varIntBytes(size) + size);
                try {
                    VarIntUtils.writeVarInt(buf, size);
                    return buf.writeBytes(this.buffer);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeHex(this.buffer));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARBINARY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteBufferMySqlParameter)) {
                return false;
            }
            ByteBufferMySqlParameter that = (ByteBufferMySqlParameter)o;
            return this.buffer.equals(that.buffer);
        }

        public int hashCode() {
            return this.buffer.hashCode();
        }
    }
}

