/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.codec.LocalTimeCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Duration;
import reactor.core.publisher.Mono;

final class DurationCodec
extends AbstractClassedCodec<Duration> {
    DurationCodec(ByteBufAllocator allocator) {
        super(allocator, Duration.class);
    }

    @Override
    public Duration decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return binary ? DurationCodec.decodeBinary(value) : DurationCodec.decodeText(value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Duration;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new DurationMySqlParameter(this.allocator, (Duration)value);
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.TIME;
    }

    static void encodeTime(ParameterWriter writer, boolean isNegative, int hours, int minutes, int seconds, int micros) {
        if (isNegative) {
            writer.append('-');
        } else {
            writer.startString();
        }
        if (hours < 10) {
            writer.append('0');
        }
        writer.writeInt(hours);
        writer.append(':');
        if (minutes < 10) {
            writer.append('0');
        }
        writer.writeInt(minutes);
        writer.append(':');
        if (seconds < 10) {
            writer.append('0');
        }
        writer.writeInt(seconds);
        if (micros > 0) {
            writer.append('.');
            for (int i = 100000; micros < i; i /= 10) {
                writer.append('0');
            }
            int m = micros;
            while (m % 10 == 0) {
                m /= 10;
            }
            writer.writeInt(m);
        }
    }

    private static Duration decodeText(ByteBuf buf) {
        boolean isNegative = LocalTimeCodec.readNegative(buf);
        int hour = DateTimes.readIntInDigits(buf);
        int minute = DateTimes.readIntInDigits(buf);
        int second = DateTimes.readIntInDigits(buf);
        int totalSeconds = hour * 3600 + minute * 60 + second;
        if (buf.isReadable()) {
            int nano = DateTimes.readMicroInDigits(buf) * 1000;
            return Duration.ofSeconds(isNegative ? (long)(-totalSeconds) : (long)totalSeconds, isNegative ? (long)(-nano) : (long)nano);
        }
        return Duration.ofSeconds(isNegative ? (long)(-totalSeconds) : (long)totalSeconds);
    }

    private static Duration decodeBinary(ByteBuf buf) {
        int bytes = buf.readableBytes();
        if (bytes < 8) {
            return Duration.ZERO;
        }
        boolean isNegative = buf.readBoolean();
        long day = buf.readUnsignedIntLE();
        byte hour = buf.readByte();
        byte minute = buf.readByte();
        byte second = buf.readByte();
        long totalSeconds = day * 86400L + (long)hour * 3600L + (long)minute * 60L + (long)second;
        if (bytes < 12) {
            return Duration.ofSeconds(isNegative ? -totalSeconds : totalSeconds);
        }
        long nanos = buf.readUnsignedIntLE() * 1000L;
        return Duration.ofSeconds(isNegative ? -totalSeconds : totalSeconds, isNegative ? -nanos : nanos);
    }

    private static final class DurationMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final Duration value;

        private DurationMySqlParameter(ByteBufAllocator allocator, Duration value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                long seconds = this.value.getSeconds();
                int nanos = this.value.getNano();
                if (seconds == 0L && nanos == 0) {
                    return this.allocator.buffer(1).writeByte(0);
                }
                boolean isNegative = this.value.isNegative();
                if (isNegative) {
                    if (nanos > 0) {
                        seconds = -(seconds + 1L);
                        nanos = 1000000000 - nanos;
                    } else {
                        seconds = -seconds;
                    }
                }
                int size = nanos > 0 ? 12 : 8;
                ByteBuf buf = this.allocator.buffer(1 + size);
                try {
                    buf.writeByte(size).writeBoolean(isNegative).writeIntLE((int)(seconds / 86400L)).writeByte((int)(seconds % 86400L / 3600L)).writeByte((int)(seconds % 3600L / 60L)).writeByte((int)(seconds % 60L));
                    if (nanos > 0) {
                        return buf.writeIntLE(nanos / 1000);
                    }
                    return buf;
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> this.encodeTo(writer));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DurationMySqlParameter)) {
                return false;
            }
            DurationMySqlParameter that = (DurationMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private void encodeTo(ParameterWriter writer) {
            boolean isNegative = this.value.isNegative();
            Duration abs = this.value.abs();
            long totalSeconds = abs.getSeconds();
            int hours = (int)(totalSeconds / 3600L);
            int minutes = (int)(totalSeconds % 3600L / 60L);
            int seconds = (int)(totalSeconds % 60L);
            int micros = abs.getNano() / 1000;
            if (hours < 0 || minutes < 0 || seconds < 0 || micros < 0) {
                throw new IllegalStateException(String.format("Duration %s abs value overflowing to %d:%02d:%02d.%06d", this.value, hours, minutes, seconds, micros));
            }
            DurationCodec.encodeTime(writer, isNegative, hours, minutes, seconds, micros);
        }
    }
}

