/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec.lob;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

abstract class SingletonLob<T> {
    private final AtomicReference<ByteBuf> buf;

    SingletonLob(ByteBuf buf) {
        this.buf = new AtomicReference<ByteBuf>(buf);
    }

    public final Mono<T> stream() {
        return Mono.defer(() -> {
            ByteBuf buf = this.buf.getAndSet(null);
            if (buf == null) {
                return Mono.error((Throwable)new IllegalStateException("Source has been released"));
            }
            try {
                Mono mono = Mono.just(this.convert(buf));
                return mono;
            }
            finally {
                buf.release();
            }
        });
    }

    public final Mono<Void> discard() {
        return Mono.fromRunnable(() -> {
            ByteBuf buf = this.buf.getAndSet(null);
            if (buf != null) {
                buf.release();
            }
        });
    }

    protected abstract T convert(ByteBuf var1);
}

