/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.collation;

import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.collation.CharsetTarget;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;

abstract class AbstractCharCollation
implements CharCollation {
    protected final int id;
    protected final String name;
    final CharsetTarget target;

    AbstractCharCollation(int id, String name, CharsetTarget target) {
        this.id = id;
        this.name = AssertUtils.requireNonNull(name, "name must not be null");
        this.target = AssertUtils.requireNonNull(target, "target must not be null");
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public int getByteSize() {
        return this.target.getByteSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCharCollation)) {
            return false;
        }
        AbstractCharCollation that = (AbstractCharCollation)o;
        return this.id == that.id && this.name.equals(that.name) && this.target.equals(that.target);
    }

    public int hashCode() {
        int hash = 31 * this.id + this.name.hashCode();
        return 31 * hash + this.target.hashCode();
    }
}

