/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlTypeMetadata;
import io.asyncer.r2dbc.mysql.api.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.api.MySqlNativeTypeMetadata;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.r2dbc.spi.Nullability;
import org.jetbrains.annotations.VisibleForTesting;

final class MySqlColumnDescriptor
implements MySqlColumnMetadata {
    private final int index;
    private final MySqlTypeMetadata typeMetadata;
    private final MySqlType type;
    private final String name;
    private final Nullability nullability;
    private final long size;
    private final int decimals;
    private final int collationId;

    @VisibleForTesting
    MySqlColumnDescriptor(int index, short typeId, String name, int definitions, long size, int decimals, int collationId) {
        AssertUtils.require(index >= 0, "index must not be a negative integer");
        AssertUtils.require(size >= 0L, "size must not be a negative integer");
        AssertUtils.require(decimals >= 0, "decimals must not be a negative integer");
        AssertUtils.requireNonNull(name, "name must not be null");
        MySqlTypeMetadata typeMetadata = new MySqlTypeMetadata(typeId, definitions, collationId);
        this.index = index;
        this.typeMetadata = typeMetadata;
        this.type = MySqlType.of(typeMetadata);
        this.name = name;
        this.nullability = typeMetadata.isNotNull() ? Nullability.NON_NULL : Nullability.NULLABLE;
        this.size = size;
        this.decimals = decimals;
        this.collationId = collationId;
    }

    static MySqlColumnDescriptor create(int index, DefinitionMetadataMessage message) {
        int definitions = message.getDefinitions();
        return new MySqlColumnDescriptor(index, message.getTypeId(), message.getColumn(), definitions, message.getSize(), message.getDecimals(), message.getCollationId());
    }

    int getIndex() {
        return this.index;
    }

    @Override
    public MySqlType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public MySqlNativeTypeMetadata getNativeTypeMetadata() {
        return this.typeMetadata;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return (int)this.size;
    }

    public Integer getScale() {
        if (this.type.isFractional() && this.decimals >= 0 && this.decimals <= 81) {
            return this.decimals;
        }
        return null;
    }

    @Override
    public CharCollation getCharCollation(CodecContext context) {
        return this.collationId == CharCollation.BINARY_ID ? context.getClientCollation() : CharCollation.fromId(this.collationId, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlColumnDescriptor)) {
            return false;
        }
        MySqlColumnDescriptor that = (MySqlColumnDescriptor)o;
        return this.index == that.index && this.size == that.size && this.decimals == that.decimals && this.collationId == that.collationId && this.typeMetadata.equals(that.typeMetadata) && this.type == that.type && this.name.equals(that.name) && this.nullability == that.nullability;
    }

    public int hashCode() {
        int hash = 31 * this.index + this.typeMetadata.hashCode();
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + this.nullability.hashCode();
        hash = 31 * hash + (int)(this.size ^ this.size >>> 32);
        hash = 31 * hash + this.decimals;
        return 31 * hash + this.collationId;
    }

    public String toString() {
        return "MySqlColumnDescriptor{index=" + this.index + ", typeMetadata=" + this.typeMetadata + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + "', nullability=" + this.nullability + ", size=" + this.size + ", decimals=" + this.decimals + ", collationId=" + this.collationId + '}';
    }
}

