/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlConnectionConfiguration;
import io.asyncer.r2dbc.mysql.MySqlConnectionFactory;
import io.asyncer.r2dbc.mysql.OptionMapper;
import io.asyncer.r2dbc.mysql.constant.CompressionAlgorithm;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import org.reactivestreams.Publisher;
import reactor.netty.resources.LoopResources;

public final class MySqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String MYSQL_DRIVER = "mysql";
    public static final Option<String> UNIX_SOCKET = Option.valueOf((String)"unixSocket");
    public static final Option<Boolean> PRESERVE_INSTANTS = Option.valueOf((String)"preserveInstants");
    public static final Option<String> CONNECTION_TIME_ZONE = Option.valueOf((String)"connectionTimeZone");
    public static final Option<Boolean> FORCE_CONNECTION_TIME_ZONE_TO_SESSION = Option.valueOf((String)"forceConnectionTimeZoneToSession");
    @Deprecated
    public static final Option<ZoneId> SERVER_ZONE_ID = Option.valueOf((String)"serverZoneId");
    public static final Option<ZeroDateOption> ZERO_DATE = Option.valueOf((String)"zeroDate");
    public static final Option<SslMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String[]> TLS_VERSION = Option.valueOf((String)"tlsVersion");
    public static final Option<String> SSL_CA = Option.valueOf((String)"sslCa");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<CharSequence> SSL_KEY_PASSWORD = Option.sensitiveValueOf((String)"sslKeyPassword");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<Boolean> TCP_KEEP_ALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NO_DELAY = Option.valueOf((String)"tcpNoDelay");
    public static final Option<Boolean> CREATE_DATABASE_IF_NOT_EXIST = Option.valueOf((String)"createDatabaseIfNotExist");
    public static final Option<Object> USE_SERVER_PREPARE_STATEMENT = Option.valueOf((String)"useServerPrepareStatement");
    public static final Option<String[]> SESSION_VARIABLES = Option.valueOf((String)"sessionVariables");
    public static final Option<String> ALLOW_LOAD_LOCAL_INFILE_IN_PATH = Option.valueOf((String)"allowLoadLocalInfileInPath");
    public static final Option<Integer> LOCAL_INFILE_BUFFER_SIZE = Option.valueOf((String)"localInfileBufferSize");
    public static final Option<CompressionAlgorithm[]> COMPRESSION_ALGORITHMS = Option.valueOf((String)"compressionAlgorithms");
    public static final Option<Integer> ZSTD_COMPRESSION_LEVEL = Option.valueOf((String)"zstdCompressionLevel");
    public static final Option<LoopResources> LOOP_RESOURCES = Option.valueOf((String)"loopResources");
    public static final Option<Integer> PREPARE_CACHE_SIZE = Option.valueOf((String)"prepareCacheSize");
    public static final Option<Integer> QUERY_CACHE_SIZE = Option.valueOf((String)"queryCacheSize");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");
    public static final Option<Publisher<String>> PASSWORD_PUBLISHER = Option.valueOf((String)"passwordPublisher");

    public ConnectionFactory create(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MySqlConnectionFactory.from(MySqlConnectionFactoryProvider.setup(options));
    }

    public boolean supports(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MYSQL_DRIVER.equals(options.getValue(ConnectionFactoryOptions.DRIVER));
    }

    public String getDriver() {
        return MYSQL_DRIVER;
    }

    static MySqlConnectionConfiguration setup(ConnectionFactoryOptions options) {
        OptionMapper mapper = new OptionMapper(options);
        MySqlConnectionConfiguration.Builder builder = MySqlConnectionConfiguration.builder();
        mapper.requires(ConnectionFactoryOptions.USER).asString().to(builder::user);
        mapper.optional(ConnectionFactoryOptions.PASSWORD).asPassword().to(builder::password);
        mapper.optional(UNIX_SOCKET).asString().to(builder::unixSocket).otherwise(() -> MySqlConnectionFactoryProvider.setupHost(builder, mapper));
        mapper.optional(PRESERVE_INSTANTS).asBoolean().to(builder::preserveInstants);
        mapper.optional(CONNECTION_TIME_ZONE).asString().to(builder::connectionTimeZone).otherwise(() -> mapper.optional(SERVER_ZONE_ID).as(ZoneId.class, id -> ZoneId.of(id, ZoneId.SHORT_IDS)).to(builder::serverZoneId));
        mapper.optional(FORCE_CONNECTION_TIME_ZONE_TO_SESSION).asBoolean().to(builder::forceConnectionTimeZoneToSession);
        mapper.optional(TCP_KEEP_ALIVE).asBoolean().to(builder::tcpKeepAlive);
        mapper.optional(TCP_NO_DELAY).asBoolean().to(builder::tcpNoDelay);
        mapper.optional(ZERO_DATE).as(ZeroDateOption.class, id -> ZeroDateOption.valueOf(id.toUpperCase())).to(builder::zeroDateOption);
        mapper.optional(USE_SERVER_PREPARE_STATEMENT).prepare(builder::useClientPrepareStatement, builder::useServerPrepareStatement, builder::useServerPrepareStatement);
        mapper.optional(ALLOW_LOAD_LOCAL_INFILE_IN_PATH).asString().to(builder::allowLoadLocalInfileInPath);
        mapper.optional(LOCAL_INFILE_BUFFER_SIZE).asInt().to(builder::localInfileBufferSize);
        mapper.optional(QUERY_CACHE_SIZE).asInt().to(builder::queryCacheSize);
        mapper.optional(PREPARE_CACHE_SIZE).asInt().to(builder::prepareCacheSize);
        mapper.optional(AUTODETECT_EXTENSIONS).asBoolean().to(builder::autodetectExtensions);
        mapper.optional(ConnectionFactoryOptions.CONNECT_TIMEOUT).as(Duration.class, Duration::parse).to(builder::connectTimeout);
        mapper.optional(ConnectionFactoryOptions.DATABASE).asString().to(builder::database);
        mapper.optional(CREATE_DATABASE_IF_NOT_EXIST).asBoolean().to(builder::createDatabaseIfNotExist);
        mapper.optional(COMPRESSION_ALGORITHMS).asArray(CompressionAlgorithm[].class, it -> CompressionAlgorithm.valueOf(it.toUpperCase()), it -> it.split(","), CompressionAlgorithm[]::new).to(builder::compressionAlgorithms);
        mapper.optional(ZSTD_COMPRESSION_LEVEL).asInt().to(builder::zstdCompressionLevel);
        mapper.optional(LOOP_RESOURCES).as(LoopResources.class).to(builder::loopResources);
        mapper.optional(PASSWORD_PUBLISHER).as(Publisher.class).to(builder::passwordPublisher);
        mapper.optional(SESSION_VARIABLES).asArray(String[].class, Function.identity(), MySqlConnectionFactoryProvider::splitVariables, String[]::new).to(builder::sessionVariables);
        mapper.optional(ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT).as(Duration.class, Duration::parse).to(builder::lockWaitTimeout);
        mapper.optional(ConnectionFactoryOptions.STATEMENT_TIMEOUT).as(Duration.class, Duration::parse).to(builder::statementTimeout);
        return builder.build();
    }

    private static void setupHost(MySqlConnectionConfiguration.Builder builder, OptionMapper mapper) {
        mapper.requires(ConnectionFactoryOptions.HOST).asString().to(builder::host);
        mapper.optional(ConnectionFactoryOptions.PORT).asInt().to(builder::port);
        mapper.optional(ConnectionFactoryOptions.SSL).asBoolean().to(isSsl -> builder.sslMode(isSsl != false ? SslMode.REQUIRED : SslMode.DISABLED));
        mapper.optional(SSL_MODE).as(SslMode.class, id -> SslMode.valueOf(id.toUpperCase())).to(builder::sslMode);
        mapper.optional(TLS_VERSION).asArray(String[].class, Function.identity(), it -> it.split(","), String[]::new).to(builder::tlsVersion);
        mapper.optional(SSL_HOSTNAME_VERIFIER).as(HostnameVerifier.class).to(builder::sslHostnameVerifier);
        mapper.optional(SSL_CERT).asString().to(builder::sslCert);
        mapper.optional(SSL_KEY).asString().to(builder::sslKey);
        mapper.optional(SSL_KEY_PASSWORD).asPassword().to(builder::sslKeyPassword);
        mapper.optional(SSL_CONTEXT_BUILDER_CUSTOMIZER).as(Function.class).to(builder::sslContextBuilderCustomizer);
        mapper.optional(SSL_CA).asString().to(builder::sslCa);
    }

    private static String[] splitVariables(String sessionVariables) {
        AssertUtils.requireNonNull(sessionVariables, "sessionVariables must not be null");
        if (sessionVariables.isEmpty()) {
            return InternalArrays.EMPTY_STRINGS;
        }
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        int index = 0;
        int len = sessionVariables.length();
        ArrayList<String> variables = new ArrayList<String>();
        block30: for (int i = 0; i < len; ++i) {
            switch (sessionVariables.charAt(i)) {
                case '\\': {
                    if (i + 1 >= len || stack.isEmpty()) continue block30;
                    switch ((Integer)stack.peekLast()) {
                        case 2: 
                        case 3: {
                            switch (sessionVariables.charAt(i + 1)) {
                                case '\"': 
                                case '\'': 
                                case '\\': 
                                case 'b': 
                                case 'f': 
                                case 'n': 
                                case 'r': 
                                case 't': {
                                    ++i;
                                }
                            }
                            continue block30;
                        }
                    }
                    continue block30;
                }
                case ',': 
                case ';': {
                    if (!stack.isEmpty()) continue block30;
                    variables.add(sessionVariables.substring(index, i).trim());
                    index = i + 1;
                    continue block30;
                }
                case '(': {
                    if (stack.isEmpty()) {
                        stack.addLast(1);
                        continue block30;
                    }
                    switch ((Integer)stack.peekLast()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            continue block30;
                        }
                    }
                    stack.addLast(1);
                    continue block30;
                }
                case ')': {
                    if (stack.isEmpty() || (Integer)stack.peekLast() != 1) continue block30;
                    stack.pollLast();
                    continue block30;
                }
                case '\'': {
                    if (stack.isEmpty()) {
                        stack.addLast(2);
                        continue block30;
                    }
                    switch ((Integer)stack.peekLast()) {
                        case 2: {
                            stack.pollLast();
                            continue block30;
                        }
                        case 3: 
                        case 4: {
                            continue block30;
                        }
                    }
                    stack.addLast(2);
                    continue block30;
                }
                case '\"': {
                    if (stack.isEmpty()) {
                        stack.addLast(3);
                        continue block30;
                    }
                    switch ((Integer)stack.peekLast()) {
                        case 3: {
                            stack.pollLast();
                            continue block30;
                        }
                        case 2: 
                        case 4: {
                            continue block30;
                        }
                    }
                    stack.addLast(3);
                    continue block30;
                }
                case '`': {
                    if (stack.isEmpty()) {
                        stack.addLast(4);
                        continue block30;
                    }
                    switch ((Integer)stack.peekLast()) {
                        case 4: {
                            stack.pollLast();
                            continue block30;
                        }
                        case 2: 
                        case 3: {
                            continue block30;
                        }
                    }
                    stack.addLast(4);
                }
            }
        }
        variables.add(sessionVariables.substring(index).trim());
        return variables.toArray(new String[0]);
    }
}

