/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlSegmentResult;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.api.MySqlBatch;
import io.asyncer.r2dbc.mysql.api.MySqlResult;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

final class MySqlSyntheticBatch
implements MySqlBatch {
    private final Client client;
    private final Codecs codecs;
    private final List<String> statements = new ArrayList<String>();

    MySqlSyntheticBatch(Client client, Codecs codecs) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
    }

    @Override
    public MySqlBatch add(String sql) {
        this.statements.add(AssertUtils.requireNonNull(sql, "sql must not be null"));
        return this;
    }

    public Flux<MySqlResult> execute() {
        return QueryFlow.execute(this.client, this.statements).map(messages -> MySqlSegmentResult.toResult(false, this.client, this.codecs, null, (Flux<ServerMessage>)messages));
    }

    public String toString() {
        return "MySqlSyntheticBatch{sql=REDACTED}";
    }
}

