/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.client.Compressor;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class ZlibCompressor
implements Compressor {
    private static final int MAX_CHUNK_SIZE = 65536;
    private final Deflater deflater = new Deflater();
    private final Inflater inflater = new Inflater();

    ZlibCompressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf compress(ByteBuf buf) {
        int len = buf.readableBytes();
        if (len == 0) {
            return buf.alloc().buffer(0, 0);
        }
        try {
            if (buf.hasArray()) {
                byte[] input = buf.array();
                int offset = buf.arrayOffset() + buf.readerIndex();
                ByteBuf out = buf.alloc().heapBuffer(Math.min(len, 65536));
                this.deflater.setInput(input, offset, len);
                this.deflater.finish();
                this.deflateAll(out, len);
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            byte[] input = new byte[Math.min(len, 65536)];
            int readerIndex = buf.readerIndex();
            int writerIndex = buf.writerIndex();
            ByteBuf out = buf.alloc().heapBuffer(Math.min(len, 65536));
            while (writerIndex - readerIndex > 0) {
                int numBytes = Math.min(input.length, writerIndex - readerIndex);
                buf.getBytes(readerIndex, input, 0, numBytes);
                this.deflater.setInput(input, 0, numBytes);
                readerIndex += numBytes;
                this.deflateAll(out, len);
            }
            this.deflater.finish();
            this.deflateAll(out, len);
            ByteBuf byteBuf = out;
            return byteBuf;
        }
        finally {
            this.deflater.reset();
        }
    }

    @Override
    public ByteBuf decompress(ByteBuf buf, int uncompressedSize) {
        int len = buf.readableBytes();
        if (len == 0) {
            return buf.alloc().buffer(0, 0);
        }
        try {
            if (buf.hasArray()) {
                byte[] input = buf.array();
                int offset = buf.arrayOffset() + buf.readerIndex();
                ByteBuf out = buf.alloc().heapBuffer(uncompressedSize);
                this.inflater.setInput(input, offset, len);
                this.inflateAll(out);
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            byte[] input = new byte[Math.min(len, 65536)];
            int readerIndex = buf.readerIndex();
            int writerIndex = buf.writerIndex();
            ByteBuf out = buf.alloc().heapBuffer(uncompressedSize);
            while (writerIndex - readerIndex > 0) {
                int numBytes = Math.min(input.length, writerIndex - readerIndex);
                buf.getBytes(readerIndex, input, 0, numBytes);
                this.inflater.setInput(input, 0, numBytes);
                readerIndex += numBytes;
                this.inflateAll(out);
            }
            ByteBuf byteBuf = out;
            return byteBuf;
        }
        catch (DataFormatException e) {
            throw new DecoderException("zlib decompress failed", (Throwable)e);
        }
        finally {
            this.inflater.reset();
        }
    }

    public void dispose() {
        this.deflater.end();
        this.inflater.end();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deflateAll(ByteBuf out, int maxSize) {
        while (true) {
            this.deflate(out);
            if (!out.isWritable()) {
                int size = out.readableBytes();
                if (size >= maxSize) return;
                if (size > maxSize >> 1) {
                    out.ensureWritable(maxSize - size);
                    continue;
                }
                out.ensureWritable(size);
                continue;
            }
            if (this.deflater.needsInput()) return;
        }
    }

    private void inflateAll(ByteBuf out) throws DataFormatException {
        while (out.isWritable() && !this.inflater.finished()) {
            int wid = out.writerIndex();
            int numBytes = this.inflater.inflate(out.array(), out.arrayOffset() + wid, out.writableBytes());
            out.writerIndex(wid + numBytes);
        }
    }

    private void deflate(ByteBuf out) {
        int wid = out.writerIndex();
        int written = this.deflater.deflate(out.array(), out.arrayOffset() + wid, out.writableBytes());
        while (written > 0) {
            out.writerIndex(wid += written);
            written = this.deflater.deflate(out.array(), out.arrayOffset() + wid, out.writableBytes());
        }
    }
}

