/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;

abstract class AbstractPrimitiveCodec<T>
implements Codec<T> {
    private final Class<T> primitiveClass;
    private final Class<T> boxedClass;

    AbstractPrimitiveCodec(Class<T> primitiveClass, Class<T> boxedClass) {
        AssertUtils.require(primitiveClass.isPrimitive() && !boxedClass.isPrimitive(), "primitiveClass must be primitive and boxedClass must not be primitive");
        this.primitiveClass = primitiveClass;
        this.boxedClass = boxedClass;
    }

    @Override
    public final boolean canDecode(MySqlReadableMetadata metadata, Class<?> target) {
        return (target.isAssignableFrom(this.boxedClass) || target.equals(this.primitiveClass)) && this.doCanDecode(metadata);
    }

    public final Class<T> getPrimitiveClass() {
        return this.primitiveClass;
    }

    @Override
    public final Class<? extends T> getMainClass() {
        return this.boxedClass;
    }

    protected abstract boolean doCanDecode(MySqlReadableMetadata var1);
}

