/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.MySqlSegmentResult;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.SimpleStatementSupport;
import io.asyncer.r2dbc.mysql.api.MySqlResult;
import io.asyncer.r2dbc.mysql.api.MySqlStatement;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;

final class PrepareSimpleStatement
extends SimpleStatementSupport {
    private static final List<Binding> BINDINGS = Collections.singletonList(new Binding(0));
    private int fetchSize = 0;

    PrepareSimpleStatement(Client client, Codecs codecs, String sql) {
        super(client, codecs, sql);
    }

    public Flux<MySqlResult> execute() {
        return Flux.defer(() -> QueryFlow.execute(this.client, StringUtils.extendReturning(this.sql, this.returningIdentifiers()), BINDINGS, this.fetchSize)).map(messages -> MySqlSegmentResult.toResult(true, this.client, this.codecs, this.syntheticKeyName(), (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }
}

