/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.math.BigInteger;
import reactor.core.publisher.Mono;

final class BooleanCodec
extends AbstractPrimitiveCodec<Boolean> {
    static final BooleanCodec INSTANCE = new BooleanCodec();

    private BooleanCodec() {
        super(Boolean.TYPE, Boolean.class);
    }

    @Override
    public Boolean decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType dataType = metadata.getType();
        if (dataType == MySqlType.VARCHAR) {
            if (!value.isReadable()) {
                return this.createFromLong(0L);
            }
            String s = value.toString(metadata.getCharCollation(context).getCharset());
            if (s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("true")) {
                return this.createFromLong(1L);
            }
            if (s.equalsIgnoreCase("N") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("false")) {
                return this.createFromLong(0L);
            }
            if (s.matches("-?\\d*\\.\\d*") || s.matches("-?\\d*\\.\\d+[eE]-?\\d+") || s.matches("-?\\d*[eE]-?\\d+")) {
                return this.createFromDouble(Double.parseDouble(s));
            }
            if (s.matches("-?\\d+")) {
                if (!CodecUtils.isGreaterThanLongMax(s)) {
                    return this.createFromLong(CodecUtils.parseLong(value));
                }
                return this.createFromBigInteger(new BigInteger(s));
            }
            throw new R2dbcNonTransientResourceException("The value '" + s + "' of type '" + (Object)((Object)dataType) + "' cannot be encoded into a Boolean.", "22018");
        }
        return binary || dataType == MySqlType.BIT ? value.readBoolean() : value.readByte() != 48;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return (Boolean)value != false ? BooleanMySqlParameter.TRUE : BooleanMySqlParameter.FALSE;
    }

    @Override
    public boolean doCanDecode(MySqlReadableMetadata metadata) {
        MySqlType type = metadata.getType();
        return (type == MySqlType.BIT || type == MySqlType.TINYINT) && Integer.valueOf(1).equals(metadata.getPrecision()) || type == MySqlType.VARCHAR;
    }

    public Boolean createFromLong(long l) {
        return l == -1L || l > 0L;
    }

    public Boolean createFromDouble(double d) {
        return d == -1.0 || d > 0.0;
    }

    public Boolean createFromBigInteger(BigInteger b) {
        return b.compareTo(BigInteger.valueOf(0L)) > 0 || b.compareTo(BigInteger.valueOf(-1L)) == 0;
    }

    private static final class BooleanMySqlParameter
    extends AbstractMySqlParameter {
        private static final BooleanMySqlParameter TRUE = new BooleanMySqlParameter(true);
        private static final BooleanMySqlParameter FALSE = new BooleanMySqlParameter(false);
        private final boolean value;

        private BooleanMySqlParameter(boolean value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> allocator.buffer(1).writeByte(this.value ? 1 : 0));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value ? 1 : 0));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TINYINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanMySqlParameter)) {
                return false;
            }
            BooleanMySqlParameter that = (BooleanMySqlParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        @Override
        public String toString() {
            return Boolean.toString(this.value);
        }
    }
}

