/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.HandshakeHeader;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;

public final class ChangeAuthMessage
implements ServerMessage {
    private final String authType;
    private final byte[] salt;

    private ChangeAuthMessage(String authType, byte[] salt) {
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
    }

    public String getAuthType() {
        return this.authType;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeAuthMessage)) {
            return false;
        }
        ChangeAuthMessage that = (ChangeAuthMessage)o;
        return this.authType.equals(that.authType) && Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        return 31 * this.authType.hashCode() + Arrays.hashCode(this.salt);
    }

    public String toString() {
        return "ChangeAuthMessage{authType='" + this.authType + "', salt=REDACTED}";
    }

    static ChangeAuthMessage decode(ByteBuf buf) {
        buf.skipBytes(1);
        String authType = HandshakeHeader.readCStringAscii(buf);
        int bytes = buf.readableBytes();
        byte[] salt = bytes > 0 && buf.getByte(buf.writerIndex() - 1) == 0 ? ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)(bytes - 1)) : ByteBufUtil.getBytes((ByteBuf)buf);
        return new ChangeAuthMessage(authType, salt);
    }
}

