/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.message.server.EofMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.asyncer.r2dbc.mysql.message.server.WarningMessage;
import io.netty.buffer.ByteBuf;

final class Eof41Message
implements EofMessage,
WarningMessage,
ServerStatusMessage {
    static final int SIZE = 5;
    private final int warnings;
    private final short serverStatuses;

    private Eof41Message(int warnings, short serverStatuses) {
        this.warnings = warnings;
        this.serverStatuses = serverStatuses;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isDone() {
        return (this.serverStatuses & 8) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Eof41Message)) {
            return false;
        }
        Eof41Message that = (Eof41Message)o;
        return this.warnings == that.warnings && this.serverStatuses == that.serverStatuses;
    }

    public int hashCode() {
        return 31 * this.warnings + this.serverStatuses;
    }

    public String toString() {
        if (this.warnings == 0) {
            return "Eof41Message{serverStatuses=" + Integer.toHexString(this.serverStatuses) + '}';
        }
        return "Eof41Message{warnings=" + this.warnings + ", serverStatuses=" + Integer.toHexString(this.serverStatuses) + '}';
    }

    static Eof41Message decode(ByteBuf buf) {
        buf.skipBytes(1);
        int warnings = buf.readUnsignedShortLE();
        return new Eof41Message(warnings, buf.readShortLE());
    }
}

