/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.IntegerConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class IntegerConverterTest {
    private IntegerConverter converter = new IntegerConverter();

    @Test
    public void convertToBoolean() {
        int xTrue = 1;
        int xFalse = 0;
        Boolean out = this.converter.toBoolean(Integer.valueOf(xTrue));
        Assert.assertNotNull((Object)out);
        Assert.assertTrue((boolean)out);
        out = this.converter.toBoolean(Integer.valueOf(xFalse));
        Assert.assertNotNull((Object)out);
        Assert.assertFalse((boolean)out);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean out = this.converter.toBoolean(null);
        Assert.assertNull((Object)out);
    }

    @Test
    public void convertToBooleanHigh() {
        Boolean out = this.converter.toBoolean(Integer.valueOf(10));
        Assert.assertTrue((boolean)out);
    }

    @Test
    public void convertToByte() throws Exception {
        Byte value = 100;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(Integer.valueOf(100)));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteOutOfRange() throws Exception {
        this.converter.toByte(Integer.valueOf(Integer.MAX_VALUE));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Byte byt = this.converter.toByte(null);
        Assert.assertNull((Object)byt);
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Character character = this.converter.toCharacter(null);
        Assert.assertNull((Object)character);
    }

    @Test
    public void convertToCharacter() throws Exception {
        Integer integer = new Integer(4);
        Character character = this.converter.toCharacter(integer);
        Assert.assertNotNull((Object)character);
        char revert = character.charValue();
        Assert.assertEquals((Object)integer, (Object)new Integer(revert));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterGreaterThanMAX() throws Exception {
        Integer integer = 1500000;
        this.converter.toCharacter(integer);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterLessThanMIN() throws Exception {
        Integer integer = -1500000;
        this.converter.toCharacter(integer);
    }

    @Test
    public void convertToDouble() {
        Integer integer = 0;
        Double d = this.converter.toDouble(integer);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)d, (double)0.0, (double)0.0);
        integer = 1;
        d = this.converter.toDouble(integer);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)1.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Assert.assertNull((Object)this.converter.toDouble(null));
    }

    @Test
    public void convertToFloat() {
        Integer integer = 0;
        Float f = this.converter.toFloat(integer);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)f.floatValue(), (double)0.0, (double)0.0);
        integer = 1;
        f = this.converter.toFloat(integer);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assert.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToShort() throws Exception {
        int i = Short.MAX_VALUE;
        int negI = Short.MIN_VALUE;
        Short out = this.converter.toShort(Integer.valueOf(i));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((long)i, (long)out.intValue());
        out = this.converter.toShort(Integer.valueOf(negI));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((long)negI, (long)out.intValue());
    }

    @Test
    public void convertToShortNull() throws Exception {
        Short out = this.converter.toShort(null);
        Assert.assertNull((Object)out);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortConvertExceptionGreaterThanMax() throws Exception {
        this.converter.toShort(Integer.valueOf(Integer.MAX_VALUE));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortConvertExceptionLessThanMin() throws Exception {
        this.converter.toShort(Integer.valueOf(Integer.MIN_VALUE));
    }

    @Test
    public void convertToLong() {
        int i = Integer.MAX_VALUE;
        int negI = Integer.MIN_VALUE;
        Long out = this.converter.toLong(Integer.valueOf(i));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((long)i, (long)out.intValue());
        out = this.converter.toLong(Integer.valueOf(negI));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((long)negI, (long)out.intValue());
    }

    @Test
    public void convertToLongNull() {
        Long out = this.converter.toLong(null);
        Assert.assertNull((Object)out);
    }

    @Test
    public void convertToString() {
        int i = Integer.MAX_VALUE;
        int negI = Integer.MIN_VALUE;
        String out = this.converter.toString(Integer.valueOf(i));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((Object)Integer.toString(i), (Object)out);
        out = this.converter.toString(Integer.valueOf(negI));
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((Object)Integer.toString(negI), (Object)out);
    }

    @Test
    public void convertToStringNull() {
        String out = this.converter.toString(null);
        Assert.assertNull((Object)out);
    }

    @Test
    public void convertToInteger() {
        Integer foo = Integer.MAX_VALUE;
        Integer out = this.converter.toInteger(foo);
        Integer n = foo;
        Integer n2 = foo = Integer.valueOf(foo + 1);
        Assert.assertNotNull((Object)out);
        Assert.assertNotSame((Object)out, (Object)foo);
        Assert.assertNotEquals((Object)out, (Object)foo);
    }

    @Test
    public void convertToIntegerNull() {
        Integer out = this.converter.toInteger(null);
        Assert.assertNull((Object)out);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<IntegerConverter> aClass = IntegerConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.INTEGER) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testCharacterDigit() {
        int i = 4;
        int intTen = 10;
        char ch = Character.forDigit(i, intTen);
        Assert.assertTrue((ch == '4' ? 1 : 0) != 0);
        int i2 = Character.digit(ch, intTen);
        Assert.assertTrue((i2 == 4 ? 1 : 0) != 0);
    }
}

