/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.ShortConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class ShortConverterTest {
    private ShortConverter converter = new ShortConverter();

    @Test
    public void convertToBoolean() {
        Short f = 0;
        Short t = 1;
        Boolean b = this.converter.toBoolean(t);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(f);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Short l = null;
        Boolean b = this.converter.toBoolean(l);
        Assert.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Short dt = -1;
        Boolean b = this.converter.toBoolean(dt);
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Short l = 0;
        Byte value = 0;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(l));
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteOutOfRange() throws Exception {
        this.converter.toByte(Short.valueOf((short)Short.MAX_VALUE));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Short shorty = new Short(4);
        Character character = this.converter.toCharacter(shorty);
        Assert.assertNotNull((Object)character);
        Assert.assertEquals((Object)Character.valueOf((char)shorty.shortValue()), (Object)character);
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Short s = null;
        Character c = this.converter.toCharacter(s);
        Assert.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterMAX() throws Exception {
        Short s = Short.MAX_VALUE;
        Character c = this.converter.toCharacter(s);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)Character.valueOf((char)s.shortValue()), (Object)c);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterMIN() throws Exception {
        Short s = Short.MIN_VALUE;
        this.converter.toCharacter(s);
    }

    @Test
    public void convertToDouble() {
        Short s = 0;
        Double d = this.converter.toDouble(s);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Short s = null;
        Double d = this.converter.toDouble(s);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() {
        Short s = Short.MAX_VALUE;
        Double d = this.converter.toDouble(s);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)32767.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToFloat() {
        Short s = 0;
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assert.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() {
        Short s = Short.MAX_VALUE;
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)32767.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() {
        Short s = 0;
        Integer i = this.converter.toInteger(s);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() {
        Short l = null;
        Integer i = this.converter.toInteger(l);
        Assert.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Short s = 1;
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)1.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Short s = null;
        Long l = this.converter.toLong(s);
        Assert.assertNull((Object)l);
    }

    @Test
    public void convertToLongMAX() {
        Short s = Short.MAX_VALUE;
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)32767.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongMIN() {
        Short s = Short.MIN_VALUE;
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)-32768.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToShort() {
        Short aShort = 0;
        Short s = this.converter.toShort(aShort);
        Assert.assertNotNull((Object)s);
        Assert.assertNotSame((Object)aShort, (Object)s);
        Assert.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() {
        Short l = null;
        Short s = this.converter.toShort(l);
        Assert.assertNull((Object)s);
    }

    @Test
    public void convertToString() {
        Short l = 0;
        String s = this.converter.toString(l);
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)"0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Short l = null;
        String s = this.converter.toString(l);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<ShortConverter> aClass = ShortConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.SHORT) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testCharacterDigit() {
        int intTen = 10;
        char ch = Character.valueOf(Short.MAX_VALUE).charValue();
        Character.digit(ch, intTen);
    }
}

