/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Json;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;

public class ADMArchiveHandlerTest {
    @Test
    public void testExportLoadEmpty() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        handler.export((OutputStream)new FileOutputStream("target/test.adm"));
        handler = new ADMArchiveHandler();
        handler.load(Paths.get("target/test.adm", new String[0]));
        Assert.assertNull((Object)handler.getMappingDefinition());
        Assert.assertNull((Object)handler.getMappingDefinitionBytes());
    }

    @Test
    public void testFileName() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        handler.setMappingDefinitionId("2");
        Assert.assertEquals((Object)"atlasmapping-UI.2.json", (Object)handler.getMappingDefinitionFileName());
        Assert.assertEquals((Object)"adm-catalog-files-2.gz", (Object)handler.getGzippedADMDigestFileName());
    }

    @Test
    public void testExportLoadPersist() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        AtlasMapping mapping = new AtlasMapping();
        mapping.setName("foo");
        byte[] mappingBytes = Json.mapper().writeValueAsBytes((Object)mapping);
        handler.setMappingDefinitionBytes((InputStream)new ByteArrayInputStream(mappingBytes));
        Assert.assertNotNull((Object)handler.getMappingDefinition());
        Assert.assertEquals((Object)"foo", (Object)handler.getMappingDefinition().getName());
        byte[] digestBytes = "dummy".getBytes();
        handler.setGzippedADMDigest((InputStream)new ByteArrayInputStream(digestBytes));
        Assert.assertNotNull((Object)handler.getGzippedADMDigestBytes());
        handler.export((OutputStream)new FileOutputStream("target/test2.adm"));
        handler = new ADMArchiveHandler();
        handler.load(Paths.get("target/test2.adm", new String[0]));
        Assert.assertNotNull((Object)handler.getMappingDefinition());
        Assert.assertEquals((Object)"foo", (Object)handler.getMappingDefinition().getName());
        Assert.assertNotNull((Object)handler.getGzippedADMDigestBytes());
        Path persistPath = Paths.get("target/test2", new String[0]);
        AtlasUtil.deleteDirectory((File)persistPath.toFile());
        persistPath.toFile().mkdirs();
        handler.setPersistDirectory(persistPath);
        handler.persist();
        Assert.assertTrue((boolean)persistPath.resolve(handler.getMappingDefinitionFileName()).toFile().exists());
        Assert.assertTrue((boolean)persistPath.resolve(handler.getGzippedADMDigestFileName()).toFile().exists());
    }

    @Test
    public void testPersistIgnoreInvalidBytes() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        byte[] mappingBytes = "no data".getBytes();
        handler.setMappingDefinitionBytes((InputStream)new ByteArrayInputStream(mappingBytes));
        Path persistPath = Paths.get("target/test3", new String[0]);
        AtlasUtil.deleteDirectory((File)persistPath.toFile());
        persistPath.toFile().mkdirs();
        handler.setPersistDirectory(persistPath);
        handler.persist();
        Assert.assertFalse((boolean)persistPath.resolve(handler.getMappingDefinitionFileName()).toFile().exists());
        handler.setMappingDefinitionBytes((InputStream)new ByteArrayInputStream(mappingBytes));
        Assert.assertNull((Object)handler.getMappingDefinition());
    }
}

