/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.NonNullValidator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NonNullValidatorTest
extends BaseValidatorTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.validator = new NonNullValidator(ValidationScope.MAPPING, "Cannot be null");
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)this.validator.supports(String.class));
        Assert.assertTrue((boolean)this.validator.supports(Integer.class));
        Assert.assertTrue((boolean)this.validator.supports(Double.class));
    }

    @Test
    public void testValidate() {
        String notNull = "notNull";
        this.validator.validate((Object)notNull, this.validations, null);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        this.validator.validate(null, this.validations, null);
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Validation validation = this.validationHelper.getAllValidations().get(0);
        Assert.assertNotNull((Object)validation);
        Assert.assertTrue((boolean)"Cannot be null".equals(validation.getMessage()));
        Assert.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assert.assertNull((Object)validation.getId());
        String empty = "";
        this.validationHelper.getAllValidations().clear();
        this.validator.validate((Object)empty, this.validations, "testValidateInvalid-2");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Assert.assertEquals((Object)ValidationScope.MAPPING, (Object)((Validation)this.validationHelper.getValidation().get(0)).getScope());
        Assert.assertEquals((Object)"testValidateInvalid-2", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }
}

