/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.StringLengthValidator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringLengthValidatorTest
extends BaseValidatorTest {
    private StringLengthValidator validator;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.validator = new StringLengthValidator(ValidationScope.MAPPING, "Must be of this length", 1, 10);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        Assert.assertFalse((boolean)this.validator.supports(Integer.class));
    }

    @Test
    public void testValidate() {
        String pass = "1112332";
        this.validator.validate((Object)pass, this.validations, "testValidate");
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        String pass = "";
        this.validator.validate((Object)pass, this.validations, "testValidateInvalid");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getAllValidations().size()));
        Validation validation = (Validation)this.validations.get(0);
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assert.assertEquals((Object)"testValidateInvalid", (Object)validation.getId());
        Assert.assertTrue((boolean)"Must be of this length".equals(validation.getMessage()));
    }
}

