/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.spi.AtlasActionProcessor;
import io.atlasmap.spi.AtlasFieldAction;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.AddSeconds;
import io.atlasmap.v2.CurrentDate;
import io.atlasmap.v2.CurrentDateTime;
import io.atlasmap.v2.CurrentTime;
import io.atlasmap.v2.DayOfMonth;
import io.atlasmap.v2.DayOfWeek;
import io.atlasmap.v2.DayOfYear;
import io.atlasmap.v2.FieldType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DateFieldActions
implements AtlasFieldAction {
    @AtlasActionProcessor(sourceType=FieldType.ANY_DATE)
    public static ZonedDateTime addDays(AddDays addDays, ZonedDateTime input) {
        if (addDays == null) {
            throw new IllegalArgumentException("AddDays action must be specified");
        }
        if (input == null) {
            return null;
        }
        return input.plusDays(addDays.getDays() == null ? 0L : (long)addDays.getDays().intValue());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY_DATE)
    public static ZonedDateTime addSeconds(AddSeconds addSeconds, ZonedDateTime input) {
        if (addSeconds == null) {
            throw new IllegalArgumentException("AddSeconds action must be specified");
        }
        if (input == null) {
            return null;
        }
        return input.plusSeconds(addSeconds.getSeconds() == null ? 0L : (long)addSeconds.getSeconds().intValue());
    }

    @AtlasActionProcessor
    public static ZonedDateTime currentDate(CurrentDate action) {
        return LocalDate.now().atStartOfDay(ZoneId.systemDefault());
    }

    @AtlasActionProcessor
    public static ZonedDateTime currentDateTime(CurrentDateTime action) {
        return LocalDate.now().atStartOfDay(ZoneId.systemDefault());
    }

    @AtlasActionProcessor
    public static ZonedDateTime currentTime(CurrentTime action) {
        return LocalTime.now().atDate(LocalDate.now()).atZone(ZoneId.systemDefault());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY_DATE)
    public static Integer dayOfMonth(DayOfMonth action, ZonedDateTime input) {
        return input == null ? null : Integer.valueOf(input.getDayOfMonth());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY_DATE)
    public static Integer dayOfWeek(DayOfWeek action, ZonedDateTime input) {
        return input == null ? null : Integer.valueOf(input.getDayOfWeek().getValue());
    }

    @AtlasActionProcessor(sourceType=FieldType.ANY_DATE)
    public static Integer dayOfYear(DayOfYear action, ZonedDateTime input) {
        return input == null ? null : Integer.valueOf(input.getDayOfYear());
    }
}

