/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.mxbean.AtlasModuleInfoMXBean;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import java.lang.reflect.Constructor;
import java.util.List;

public class DefaultAtlasModuleInfo
implements AtlasModuleInfo,
AtlasModuleInfoMXBean {
    private String name;
    private String uri;
    private Boolean sourceSupported;
    private Boolean targetSupported;
    private Class<AtlasModule> moduleClass;
    private Constructor<AtlasModule> constructor;
    private List<String> formats;
    private List<String> packageNames;

    public DefaultAtlasModuleInfo(String name, String uri, Class<AtlasModule> moduleClass, Constructor<AtlasModule> constructor, List<String> formats, List<String> packageNames) {
        this.name = name;
        this.uri = uri;
        this.moduleClass = moduleClass;
        this.constructor = constructor;
        this.formats = formats;
        this.packageNames = packageNames;
    }

    public String getModuleClassName() {
        if (this.moduleClass != null) {
            return this.moduleClass.getName();
        }
        return null;
    }

    public Constructor<AtlasModule> getConstructor() {
        return this.constructor;
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public Class<AtlasModule> getModuleClass() {
        return this.moduleClass;
    }

    public String[] getDataFormats() {
        if (this.formats != null) {
            return this.formats.toArray(new String[this.formats.size()]);
        }
        return new String[0];
    }

    public String[] getPackageNames() {
        if (this.packageNames == null || this.packageNames.size() < 1) {
            return new String[0];
        }
        return this.packageNames.toArray(new String[this.packageNames.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public Boolean isSourceSupported() {
        return this.sourceSupported;
    }

    public Boolean isTargetSupported() {
        return this.targetSupported;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String toString() {
        return "DefaultAtlasModuleInfo [name=" + this.name + ", uri=" + this.uri + ", sourceSupported=" + this.sourceSupported + ", targetSupported=" + this.targetSupported + ", moduleClass=" + this.moduleClass + ", constructor=" + this.constructor + ", formats=" + this.formats + ", packageNames=" + this.packageNames + "]";
    }
}

