/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeValidator
implements AtlasValidator {
    private List<AtlasValidator> validators;

    public CompositeValidator(List<AtlasValidator> validators) {
        this.validators = new ArrayList<AtlasValidator>(validators);
    }

    public CompositeValidator(AtlasValidator ... validators) {
        this.validators = new ArrayList<AtlasValidator>();
        Collections.addAll(this.validators, validators);
    }

    public boolean supports(Class<?> clazz) {
        for (AtlasValidator validator : this.validators) {
            if (!validator.supports(clazz)) continue;
            return true;
        }
        return false;
    }

    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        for (AtlasValidator validator : this.validators) {
            validator.validate(target, validations, id, status);
        }
    }
}

