/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.NumberFieldActions;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Add;
import io.atlasmap.v2.AreaUnitType;
import io.atlasmap.v2.Average;
import io.atlasmap.v2.Ceiling;
import io.atlasmap.v2.ConvertAreaUnit;
import io.atlasmap.v2.ConvertDistanceUnit;
import io.atlasmap.v2.ConvertMassUnit;
import io.atlasmap.v2.ConvertVolumeUnit;
import io.atlasmap.v2.DistanceUnitType;
import io.atlasmap.v2.Divide;
import io.atlasmap.v2.Floor;
import io.atlasmap.v2.MassUnitType;
import io.atlasmap.v2.Maximum;
import io.atlasmap.v2.Minimum;
import io.atlasmap.v2.Multiply;
import io.atlasmap.v2.Round;
import io.atlasmap.v2.Subtract;
import io.atlasmap.v2.VolumeUnitType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumberFieldActionsTest {
    @Test
    public void testAbsoluteValue() {
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), null));
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)BigDecimal.valueOf(-1L)));
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)-1.0));
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)Float.valueOf(-1.0f)));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)new AtomicLong(-1L)));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)-1L));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)new AtomicInteger(-1)));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)-1));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((AbsoluteValue)new AbsoluteValue(), (Number)-1));
    }

    @Test
    public void testAdd() {
        Assertions.assertEquals((Object)BigDecimal.valueOf(10.0), (Object)NumberFieldActions.add((Add)new Add(), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)10.0, (Object)NumberFieldActions.add((Add)new Add(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)10L, (Object)NumberFieldActions.add((Add)new Add(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.add((Add)new Add(), null));
        Assertions.assertEquals((Object)10L, (Object)NumberFieldActions.add((Add)new Add(), Arrays.asList(null, 1, 2, 3, null, 4, null)));
    }

    @Test
    public void testAverage() {
        Assertions.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Average)new Average(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Average)new Average(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.average((Average)new Average(), null));
    }

    @Test
    public void testCeiling() {
        Assertions.assertEquals((Object)0L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), null));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)BigDecimal.valueOf(1.1)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)1.1));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)Float.valueOf(1.1f)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)new AtomicLong(2L)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)2L));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)new AtomicInteger(2)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)2));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Ceiling)new Ceiling(), (Number)2));
    }

    @Test
    public void testConvertAreaUnit() {
        ConvertAreaUnit action = new ConvertAreaUnit();
        action.setFromUnit(AreaUnitType.SQUARE_METER);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)1.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assertions.assertEquals((Object)21.527820833419447, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)2.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assertions.assertEquals((Object)1.1583064756273378, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)3000000.0));
        action.setFromUnit(AreaUnitType.SQUARE_FOOT);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assertions.assertEquals((Object)3.7161215999999997, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)40.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assertions.assertEquals((Object)5.0, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)5.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assertions.assertEquals((Object)2.1522038567493116, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)6.0E7));
        action.setFromUnit(AreaUnitType.SQUARE_MILE);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assertions.assertEquals((Object)1.8129916772352E7, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)7.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assertions.assertEquals((Object)2.230272E8, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)8.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assertions.assertEquals((Object)9.0, (Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)9.0));
        Assertions.assertNotNull((Object)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)action, (Number)new BigDecimal("9")));
    }

    @Test
    public void testConvertDistanceUnit() {
        ConvertDistanceUnit action = new ConvertDistanceUnit();
        action.setFromUnit(DistanceUnitType.METER_M);
        action.setToUnit(DistanceUnitType.METER_M);
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)1.0));
        action.setToUnit(DistanceUnitType.FOOT_FT);
        Assertions.assertEquals((Object)6.561679790026247, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)2.0));
        action.setToUnit(DistanceUnitType.YARD_YD);
        Assertions.assertEquals((Object)3.2808398950131235, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)3.0));
        action.setToUnit(DistanceUnitType.MILE_MI);
        Assertions.assertEquals((Object)2.4854847689493362, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)4000.0));
        action.setToUnit(DistanceUnitType.INCH_IN);
        Assertions.assertEquals((Object)196.8503937007874, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)5.0));
        action.setFromUnit(DistanceUnitType.FOOT_FT);
        action.setToUnit(DistanceUnitType.METER_M);
        Assertions.assertEquals((Object)1.8287999999999998, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)6.0));
        action.setToUnit(DistanceUnitType.FOOT_FT);
        Assertions.assertEquals((Object)7.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)7.0));
        action.setToUnit(DistanceUnitType.YARD_YD);
        Assertions.assertEquals((Object)27.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)81.0));
        action.setToUnit(DistanceUnitType.MILE_MI);
        Assertions.assertEquals((Object)1.7045454545454546, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)9000.0));
        action.setToUnit(DistanceUnitType.INCH_IN);
        Assertions.assertEquals((Object)12.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)1.0));
        action.setFromUnit(DistanceUnitType.YARD_YD);
        action.setToUnit(DistanceUnitType.METER_M);
        Assertions.assertEquals((Object)22.86, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)25.0));
        action.setToUnit(DistanceUnitType.FOOT_FT);
        Assertions.assertEquals((Object)9.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)3.0));
        action.setToUnit(DistanceUnitType.YARD_YD);
        Assertions.assertEquals((Object)4.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)4.0));
        action.setToUnit(DistanceUnitType.MILE_MI);
        Assertions.assertEquals((Object)2.840909090909091, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)5000.0));
        action.setToUnit(DistanceUnitType.INCH_IN);
        Assertions.assertEquals((Object)216.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)6.0));
        action.setFromUnit(DistanceUnitType.MILE_MI);
        action.setToUnit(DistanceUnitType.METER_M);
        Assertions.assertEquals((Object)11265.408, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)7.0));
        action.setToUnit(DistanceUnitType.FOOT_FT);
        Assertions.assertEquals((Object)42240.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)8.0));
        action.setToUnit(DistanceUnitType.YARD_YD);
        Assertions.assertEquals((Object)15840.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)9.0));
        action.setToUnit(DistanceUnitType.MILE_MI);
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)1.0));
        action.setToUnit(DistanceUnitType.INCH_IN);
        Assertions.assertEquals((Object)126720.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)2.0));
        action.setFromUnit(DistanceUnitType.INCH_IN);
        action.setToUnit(DistanceUnitType.METER_M);
        Assertions.assertEquals((Object)7.62, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)300.0));
        action.setToUnit(DistanceUnitType.FOOT_FT);
        Assertions.assertEquals((Object)3.5, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)42.0));
        action.setToUnit(DistanceUnitType.YARD_YD);
        Assertions.assertEquals((Object)1.5, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)54.0));
        action.setToUnit(DistanceUnitType.MILE_MI);
        Assertions.assertEquals((Object)9.469696969696969, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)600000.0));
        action.setToUnit(DistanceUnitType.INCH_IN);
        Assertions.assertEquals((Object)6.0, (Object)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)action, (Number)6.0));
    }

    @Test
    public void testConvertMassUnit() {
        ConvertMassUnit action = new ConvertMassUnit();
        action.setFromUnit(MassUnitType.KILOGRAM_KG);
        action.setToUnit(MassUnitType.POUND_LB);
        Assertions.assertEquals((int)11, (int)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, (Number)5).intValue());
        action.setFromUnit(MassUnitType.POUND_LB);
        action.setToUnit(MassUnitType.KILOGRAM_KG);
        Assertions.assertEquals((float)4.5359235f, (float)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, (Number)Float.valueOf(10.0f)).floatValue(), (float)0.0f);
        Assertions.assertEquals((int)0, (int)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, null).intValue());
    }

    @Test
    public void testConvertMassUnitErrorNoFromNorToSpecified() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ConvertMassUnit action = new ConvertMassUnit();
            Assertions.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, (Number)5));
        });
    }

    @Test
    public void testConvertMassUnitErrorNoFromSpecified() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ConvertMassUnit action = new ConvertMassUnit();
            action.setToUnit(MassUnitType.POUND_LB);
            Assertions.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, (Number)5));
        });
    }

    @Test
    public void testConvertMassUnitErrorNoToSpecified() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ConvertMassUnit action = new ConvertMassUnit();
            action.setFromUnit(MassUnitType.KILOGRAM_KG);
            Assertions.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((ConvertMassUnit)action, (Number)5));
        });
    }

    @Test
    public void testConvertVolumeUnit() {
        ConvertVolumeUnit action = new ConvertVolumeUnit();
        action.setFromUnit(VolumeUnitType.CUBIC_METER);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)1.0));
        action.setToUnit(VolumeUnitType.LITER);
        Assertions.assertEquals((Object)2000.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)2.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assertions.assertEquals((Object)105.94400016446578, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)3.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assertions.assertEquals((Object)1056.68820944, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)4.0));
        action.setFromUnit(VolumeUnitType.LITER);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assertions.assertEquals((Object)5.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)5000.0));
        action.setToUnit(VolumeUnitType.LITER);
        Assertions.assertEquals((Object)6.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)6.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assertions.assertEquals((Object)2.4720266705042016, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)70.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assertions.assertEquals((Object)2.11337641888, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)8.0));
        action.setFromUnit(VolumeUnitType.CUBIC_FOOT);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assertions.assertEquals((Object)2.54851619328, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)90.0));
        action.setToUnit(VolumeUnitType.LITER);
        Assertions.assertEquals((Object)28.316846591999997, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)1.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assertions.assertEquals((Object)2.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)2.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assertions.assertEquals((Object)22.441558441715735, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)3.0));
        action.setFromUnit(VolumeUnitType.GALLON_US_FLUID);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assertions.assertEquals((Object)1.5141647135893872, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)400.0));
        action.setToUnit(VolumeUnitType.LITER);
        Assertions.assertEquals((Object)18.92705891986734, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)5.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assertions.assertEquals((Object)8.020833333277116, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)60.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assertions.assertEquals((Object)7.0, (Object)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)action, (Number)7.0));
    }

    @Test
    public void testDivide() {
        Assertions.assertEquals((Object)BigDecimal.valueOf(2L), (Object)NumberFieldActions.divide((Divide)new Divide(), Arrays.asList(BigDecimal.valueOf(4L), BigDecimal.valueOf(2L))));
        Assertions.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Divide)new Divide(), Arrays.asList(4.0, 2.0)));
        Assertions.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Divide)new Divide(), Arrays.asList(4, 2)));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.divide((Divide)new Divide(), null));
        Assertions.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Divide)new Divide(), Arrays.asList(null, 4, null, 2, null)));
    }

    @Test
    public void testFloor() {
        Assertions.assertEquals((Object)0L, (Object)NumberFieldActions.floor((Floor)new Floor(), null));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)BigDecimal.valueOf(1.5)));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)1.5));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)Float.valueOf(1.5f)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)new AtomicLong(2L)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)2L));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)new AtomicInteger(2)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)2));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Floor)new Floor(), (Number)2));
    }

    @Test
    public void testMaximum() {
        Assertions.assertEquals((Object)BigDecimal.valueOf(4L), (Object)NumberFieldActions.maximum((Maximum)new Maximum(), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)4.0, (Object)NumberFieldActions.maximum((Maximum)new Maximum(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)4, (Object)NumberFieldActions.maximum((Maximum)new Maximum(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)BigDecimal.valueOf(4L), (Object)NumberFieldActions.maximum((Maximum)new Maximum(), Arrays.asList((byte)1, 2, 3.0, BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.maximum((Maximum)new Maximum(), null));
        Assertions.assertEquals((Object)4, (Object)NumberFieldActions.maximum((Maximum)new Maximum(), Arrays.asList(null, 1, 2, 3, null, 4, null)));
    }

    @Test
    public void testMinimum() {
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)NumberFieldActions.minimum((Minimum)new Minimum(), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)1.0, (Object)NumberFieldActions.minimum((Minimum)new Minimum(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Minimum)new Minimum(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Minimum)new Minimum(), Arrays.asList((byte)1, 2, 3.0, BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.minimum((Minimum)new Minimum(), null));
        Assertions.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Minimum)new Minimum(), Arrays.asList(null, 1, 2, null, 3, 4, null)));
    }

    @Test
    public void testRound() {
        Assertions.assertEquals((Object)0L, (Object)NumberFieldActions.round((Round)new Round(), null));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)BigDecimal.valueOf(1.5)));
        Assertions.assertEquals((Object)1L, (Object)NumberFieldActions.round((Round)new Round(), (Number)1.4));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)Float.valueOf(1.5f)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)new AtomicLong(2L)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)2L));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)new AtomicInteger(2)));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)2));
        Assertions.assertEquals((Object)2L, (Object)NumberFieldActions.round((Round)new Round(), (Number)2));
    }

    @Test
    public void testSubtract() {
        Assertions.assertEquals((Object)BigDecimal.valueOf(-8.0), (Object)NumberFieldActions.subtract((Subtract)new Subtract(), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)-8.0, (Object)NumberFieldActions.subtract((Subtract)new Subtract(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)-8L, (Object)NumberFieldActions.subtract((Subtract)new Subtract(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.subtract((Subtract)new Subtract(), null));
        Assertions.assertEquals((Object)-8.0, (Object)NumberFieldActions.subtract((Subtract)new Subtract(), Arrays.asList(null, 1.0, null, 2.0, 3.0, null, 4.0, null)));
    }

    @Test
    public void testConvertMassUnitIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertEquals((int)11, (int)NumberFieldActions.convertMassUnit((ConvertMassUnit)new ConvertMassUnit(), (Number)5).intValue()));
    }

    @Test
    public void testConvertDistanceUnitIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Assertions.assertEquals((int)0, (int)NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)new ConvertDistanceUnit(), null).intValue());
            NumberFieldActions.convertDistanceUnit((ConvertDistanceUnit)new ConvertDistanceUnit(), (Number)5);
        });
    }

    @Test
    public void testConvertAreaUnitIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Assertions.assertEquals((int)0, (int)NumberFieldActions.convertAreaUnit((ConvertAreaUnit)new ConvertAreaUnit(), null).intValue());
            NumberFieldActions.convertAreaUnit((ConvertAreaUnit)new ConvertAreaUnit(), (Number)5);
        });
    }

    @Test
    public void testConvertVolumeUnitIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Assertions.assertEquals((int)0, (int)NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)new ConvertVolumeUnit(), null).intValue());
            NumberFieldActions.convertVolumeUnit((ConvertVolumeUnit)new ConvertVolumeUnit(), (Number)5);
        });
    }

    @Test
    public void testMultiply() {
        Assertions.assertNotNull((Object)new NumberFieldActions());
        Assertions.assertEquals((Object)0, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), null));
        Assertions.assertEquals((Object)new BigDecimal("24.0000"), (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assertions.assertEquals((Object)24.0, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(1.0, 2.0, 3.0, 4.0)));
        Assertions.assertEquals((Object)24.0, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f))));
        Assertions.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(1L, 2L, 3L, 4L)));
        Assertions.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(1, 2, 3, 4)));
        Assertions.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Multiply)new Multiply(), Arrays.asList(null, 1, 2, null, 3, 4, null)));
    }
}

