/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.ObjectFieldActions;
import io.atlasmap.v2.Contains;
import io.atlasmap.v2.Count;
import io.atlasmap.v2.Equals;
import io.atlasmap.v2.ItemAt;
import io.atlasmap.v2.Length;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectFieldActionsTest {
    @Test
    public void testCount() {
        Assertions.assertEquals((Integer)0, (Integer)ObjectFieldActions.count((Count)new Count(), new ArrayList()));
        Object[] array = new Object[]{false, "foo", 2};
        Assertions.assertEquals((Integer)3, (Integer)ObjectFieldActions.count((Count)new Count(), Arrays.asList(array)));
    }

    @Test
    public void testContains() {
        Contains action = new Contains();
        Assertions.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("")));
        Object[] array = new Object[]{false, "foo", 2};
        Object[] arrayWithNull = new Object[]{false, null, "foo", 2};
        Assertions.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(array)));
        Assertions.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(arrayWithNull)));
        action.setValue("foo");
        Assertions.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("")));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("foobar")));
        Assertions.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(array)));
    }

    @Test
    public void testContainsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldActions.contains(null, Arrays.asList("")));
    }

    @Test
    public void testEquals() {
        Equals action = new Equals();
        Assertions.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, null));
        action.setValue("6");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)169));
        action.setValue("169");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)169));
        action.setValue("ru");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)true));
        action.setValue("true");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)true));
        action.setValue("b");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)Character.valueOf('a')));
        action.setValue("a");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)Character.valueOf('a')));
    }

    @Test
    public void testEqualsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldActions.equals(null, (Object)""));
    }

    @Test
    public void testIsNull() {
        Assertions.assertTrue((boolean)ObjectFieldActions.isNull(null, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)""));
        Assertions.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)new Object[0]));
    }

    @Test
    public void testItemAt() {
        ItemAt action = new ItemAt();
        action.setIndex(Integer.valueOf(0));
        Assertions.assertEquals((Object)"one", (Object)ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two")));
        action.setIndex(Integer.valueOf(1));
        Assertions.assertEquals((Object)"two", (Object)ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two")));
    }

    @Test
    public void testItemAtOutOfBounds() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> {
            ItemAt action = new ItemAt();
            action.setIndex(Integer.valueOf(2));
            ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two"));
        });
    }

    @Test
    public void testLength() {
        Assertions.assertEquals((Integer)-1, (Integer)ObjectFieldActions.length((Length)new Length(), null));
        Assertions.assertEquals((Integer)0, (Integer)ObjectFieldActions.length((Length)new Length(), (Object)""));
        Assertions.assertEquals((Integer)5, (Integer)ObjectFieldActions.length((Length)new Length(), (Object)" foo "));
        Assertions.assertEquals((Integer)4, (Integer)ObjectFieldActions.length((Length)new Length(), (Object)true));
        Assertions.assertEquals((Integer)3, (Integer)ObjectFieldActions.length((Length)new Length(), (Object)169));
    }
}

