/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.builder;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.builder.DefaultAtlasMappingBuilder;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.v2.FieldType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultAtlasMappingBuilderTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void test() throws Exception {
        DefaultAtlasMappingBuilder builder = new DefaultAtlasMappingBuilder(){

            public void processMapping() throws Exception {
                this.read("ATLAS_DEFAULT_SOURCE_DOC", "/f1").write("ATLAS_DEFAULT_TARGET_DOC", "/f2");
                this.readConstant("c3").writeProperty("ATLAS_DEFAULT_TARGET_DOC", "p4");
                this.readProperty("ATLAS_DEFAULT_SOURCE_DOC", "p5").write("ATLAS_DEFAULT_TARGET_DOC", "/f6");
                this.write("ATLAS_DEFAULT_TARGET_DOC", "/f7", "f7value");
            }
        };
        this.populateConstant("c3", "c3value");
        this.populateSourceField("ATLAS_DEFAULT_SOURCE_DOC", FieldType.STRING, "f1", (Object)"f1value");
        this.populateProperty("ATLAS_DEFAULT_SOURCE_DOC", "p5", "p5value");
        builder.setAtlasSession((AtlasSession)this.session);
        builder.processMapping();
        Assertions.assertEquals((int)0, (int)this.session.getAudits().getAudit().size(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"f1value", (Object)this.getTargetFieldValue("/f2"));
        Assertions.assertEquals((Object)"c3value", this.session.getTargetProperties().get("p4"));
        Assertions.assertEquals((Object)"p5value", (Object)this.getTargetFieldValue("/f6"));
        Assertions.assertEquals((Object)"f7value", (Object)this.getTargetFieldValue("/f7"));
    }
}

