/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.DateTimeHelper;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SqlDateConverter
implements AtlasConverter<java.sql.Date> {
    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(java.sql.Date date) {
        return date != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public Date toDate(java.sql.Date date, String sourceFormat, String targetFormat) {
        return date != null ? DateTimeHelper.convertSqlDateToDate(date, sourceFormat) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(java.sql.Date date) {
        return date != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE)
    public LocalDate toLocalDate(java.sql.Date date) {
        return date != null ? date.toLocalDate() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(java.sql.Date date) {
        return date != null ? date.toLocalDate().atStartOfDay() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public Timestamp toSqlTimestamp(java.sql.Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(java.sql.Date date) {
        return date != null ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()) : null;
    }
}

