/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasCollectionHelper;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSourceMetadata;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="ConstantModule", uri="", modes={"SOURCE"}, dataFormats={}, configPackages={})
public class ConstantModule
implements AtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantModule.class);
    private AtlasConversionService conversionService;
    private AtlasFieldActionService fieldActionService;
    private AtlasCollectionHelper collectionHelper;
    private ClassLoader classLoader;

    public void init() {
    }

    public void destroy() {
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void processPreValidation(AtlasInternalSession session) throws AtlasException {
    }

    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        if (!(sourceField instanceof ConstantField)) {
            return;
        }
        if (this.getConversionService() != null && sourceField.getFieldType() != null && sourceField.getValue() != null) {
            sourceField.setValue(this.getConversionService().convertType(sourceField.getValue(), null, this.getConversionService().classFromFieldType(sourceField.getFieldType()), null));
        } else if (sourceField.getFieldType() == null) {
            sourceField.setFieldType(FieldType.STRING);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processed source ConstantField sPath=" + sourceField.getPath() + " sV=" + sourceField.getValue() + " sT=" + sourceField.getFieldType() + " docId: " + sourceField.getDocId());
        }
    }

    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    public void processPostValidation(AtlasInternalSession session) throws AtlasException {
    }

    public AtlasModuleMode getMode() {
        return AtlasModuleMode.SOURCE;
    }

    public void setMode(AtlasModuleMode atlasModuleMode) {
    }

    public AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.conversionService = atlasConversionService;
    }

    public List<AtlasModuleMode> listSupportedModes() {
        return Arrays.asList(AtlasModuleMode.SOURCE);
    }

    public String getDocId() {
        return null;
    }

    public void setDocId(String docId) {
    }

    public String getUri() {
        return null;
    }

    public void setUri(String uri) {
    }

    public Boolean isStatisticsSupported() {
        return false;
    }

    public Boolean isStatisticsEnabled() {
        return false;
    }

    public Boolean isSupportedField(Field field) {
        return field instanceof ConstantField;
    }

    public Field cloneField(Field field) throws AtlasException {
        return null;
    }

    public AtlasFieldActionService getFieldActionService() {
        return this.fieldActionService;
    }

    public void setFieldActionService(AtlasFieldActionService atlasFieldActionService) {
        this.fieldActionService = atlasFieldActionService;
        this.collectionHelper = new DefaultAtlasCollectionHelper(atlasFieldActionService);
    }

    public AtlasCollectionHelper getCollectionHelper() {
        return this.collectionHelper;
    }

    public String getUriDataType() {
        return null;
    }

    public Map<String, String> getUriParameters() {
        return null;
    }

    public void setDataSourceMetadata(DataSourceMetadata meta) {
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return null;
    }

    public void setDocName(String docName) {
    }

    public String getDocName() {
        return "Constants";
    }

    public ConstantField createField() {
        return new ConstantField();
    }
}

