/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.dfdl.inspect;

import io.atlasmap.api.AtlasException;
import io.atlasmap.dfdl.core.DfdlSchemaResolver;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.inspect.XmlInstanceInspector;
import io.atlasmap.xml.inspect.XmlSchemaInspector;
import io.atlasmap.xml.v2.XmlDocument;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.daffodil.japi.Compiler;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class DfdlInspector {
    private static final Logger LOG = LoggerFactory.getLogger(DfdlInspector.class);
    private ClassLoader classLoader;
    private DfdlSchemaResolver schemaResolver;
    private XmlInstanceInspector xmlInstanceInspector = new XmlInstanceInspector();
    private XmlSchemaInspector xmlSchemaInspector = new XmlSchemaInspector();
    private XmlDocument output;

    public DfdlInspector(ClassLoader loader) {
        this.classLoader = loader;
        this.xmlSchemaInspector.setClassLoader(loader);
        this.schemaResolver = new DfdlSchemaResolver(loader);
    }

    public void inspectInstance(String dfdlSchemaName, Map<String, String> options) throws Exception {
        String example = options.get("atlas.dfdl.example");
        if (example == null) {
            LOG.error("DFDL instance inspection requires example data, but it was not specified");
            return;
        }
        Compiler c = Daffodil.compiler();
        ProcessorFactory pf = c.compileSource(this.schemaResolver.resolve(dfdlSchemaName, options));
        DataProcessor dp = pf.onPath("/");
        W3CDOMInfosetOutputter output = new W3CDOMInfosetOutputter();
        ParseResult result = dp.parse(new InputSourceDataInputStream(example.getBytes()), (InfosetOutputter)output);
        if (result.isError()) {
            StringBuffer buf = new StringBuffer("DFDL inspection failed");
            result.getDiagnostics().forEach(d -> buf.append("; ").append(d.getMessage()));
            throw new AtlasException(buf.toString());
        }
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace(new XmlIOHelper(this.classLoader).writeDocumentToString(false, (Node)output.getResult()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.xmlInstanceInspector.inspect(output.getResult());
        this.output = this.xmlInstanceInspector.getXmlDocument();
    }

    public void inspectSchema(String dfdlSchemaName, Map<String, String> options) throws Exception {
        URI uri = this.schemaResolver.resolve(dfdlSchemaName, options);
        this.xmlSchemaInspector.inspect(new File(uri));
        this.output = this.xmlSchemaInspector.getXmlDocument();
    }

    public XmlDocument getXmlDocument() {
        return this.output;
    }
}

