/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core.accessor;

import io.atlasmap.api.AtlasException;
import io.atlasmap.java.core.ClassHelper;
import io.atlasmap.v2.CollectionType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class JavaChildAccessor {
    private Object parent;
    private String name;
    private CollectionType collectionType;
    private List<Object> collectionValues;
    private Class<?> fieldClass;

    public JavaChildAccessor(Object parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public abstract Object getRawValue() throws AtlasException;

    public abstract Type getRawGenericType() throws AtlasException;

    public abstract Class<?> getRawClass() throws AtlasException;

    public Object getParentObject() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public CollectionType getCollectionType() throws AtlasException {
        if (this.collectionType != null) {
            return this.collectionType;
        }
        if (this.getRawClass().isArray()) {
            this.collectionType = CollectionType.ARRAY;
            this.collectionValues = new ArrayList<Object>();
            for (int i = 0; this.getRawValue() != null && i < Array.getLength(this.getRawValue()); ++i) {
                this.collectionValues.add(Array.get(this.getRawValue(), i));
            }
        } else if (this.getRawValue() instanceof Collection) {
            this.collectionType = CollectionType.LIST;
            this.collectionValues = this.getRawValue() instanceof List ? (List<Object>)this.getRawValue() : Arrays.asList(((Collection)Collection.class.cast(this.getRawValue())).toArray());
        } else if (this.getRawValue() instanceof Map) {
            this.collectionType = CollectionType.MAP;
            this.collectionValues = Arrays.asList(((Map)Map.class.cast(this.getRawValue())).values().toArray());
        } else {
            this.collectionType = CollectionType.NONE;
        }
        return this.collectionType;
    }

    public List<?> getCollectionValues() throws AtlasException {
        this.getCollectionType();
        return this.collectionValues;
    }

    public Class<?> getFieldClass() throws AtlasException {
        if (this.fieldClass != null) {
            return this.fieldClass;
        }
        if (this.getCollectionType() == CollectionType.NONE) {
            this.fieldClass = this.getRawClass();
        } else if (this.getCollectionType() == CollectionType.ARRAY) {
            this.fieldClass = this.getRawClass().getComponentType();
        } else {
            if (this.getCollectionType() == CollectionType.LIST) {
                return ClassHelper.detectClassFromTypeArgument(this.getRawGenericType());
            }
            if (this.getCollectionType() == CollectionType.MAP) {
                return ClassHelper.detectClassFromTypeArgumentAt(this.getRawGenericType(), 1);
            }
        }
        return this.fieldClass;
    }

    public Object getValue() throws AtlasException {
        if (this.getCollectionType() == CollectionType.NONE) {
            return this.getRawValue();
        }
        return this.collectionValues.size() > 0 ? this.collectionValues.get(0) : null;
    }

    public Object getValueAt(int pos) throws AtlasException {
        if (this.getCollectionType() == CollectionType.NONE) {
            return this.getRawValue();
        }
        return this.collectionValues.size() > pos ? this.collectionValues.get(pos) : null;
    }
}

