/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.java.core.JavaFieldWriterUtil;
import io.atlasmap.java.core.TargetValueConverter;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupTable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFieldWriter
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFieldWriter.class);
    private Object rootObject = null;
    private JavaFieldWriterUtil writerUtil;
    private TargetValueConverter converter;
    private Map<String, Object> pathParentQueue = new LinkedHashMap<String, Object>();
    private Class<?> collectionItemClass = null;

    public JavaFieldWriter(JavaFieldWriterUtil util) {
        this.writerUtil = util;
    }

    public Object prepareParentObject(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        if (targetField == null) {
            throw new AtlasException("Target field cannot be null");
        }
        try {
            AtlasPath path = new AtlasPath(targetField.getPath());
            if (path.isRoot().booleanValue()) {
                return null;
            }
            if (this.rootObject == null) {
                throw new IllegalArgumentException("A root object must be set before process");
            }
            AtlasPath.SegmentContext rootSegment = path.getRootSegment();
            Object parentObject = this.rootObject;
            if (rootSegment.getCollectionType() != CollectionType.NONE) {
                if (this.collectionItemClass == null) {
                    throw new AtlasException(String.format("Collection item class must be specified to handle topmost collection, path=", path.toString()));
                }
                if (rootSegment.getCollectionIndex() == null) {
                    return null;
                }
                parentObject = this.writerUtil.getCollectionItem(this.rootObject, rootSegment);
                if (parentObject == null) {
                    this.rootObject = this.writerUtil.adjustCollectionSize(this.rootObject, rootSegment);
                    parentObject = this.writerUtil.createComplexCollectionItem(this.rootObject, this.collectionItemClass, rootSegment);
                }
            }
            for (AtlasPath.SegmentContext segmentContext : path.getSegments(false)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now processing segment: " + segmentContext);
                    LOG.debug("Parent object is currently: " + this.writeDocumentToString(false, parentObject));
                }
                if (segmentContext == path.getLastSegment()) {
                    return parentObject;
                }
                Object childObject = this.writerUtil.getChildObject(parentObject, segmentContext);
                if (childObject == null) {
                    childObject = this.writerUtil.createComplexChildObject(parentObject, segmentContext);
                }
                if (segmentContext.getCollectionType() != CollectionType.NONE) {
                    if (segmentContext.getCollectionIndex() == null) {
                        return null;
                    }
                    Object item = this.writerUtil.getCollectionItem(childObject, segmentContext);
                    if (item == null) {
                        Object adjusted = this.writerUtil.adjustCollectionSize(childObject, segmentContext);
                        if (adjusted != childObject) {
                            this.writerUtil.setChildObject(parentObject, adjusted, segmentContext);
                        }
                        item = this.writerUtil.createComplexCollectionItem(parentObject, adjusted, segmentContext);
                    }
                    childObject = item;
                }
                parentObject = childObject;
            }
            return null;
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error occured while preparing parent object for: " + targetField.getPath(), t);
            }
            if (t instanceof AtlasException) {
                throw (AtlasException)t;
            }
            throw new AtlasException(t);
        }
    }

    public void populateTargetFieldValue(AtlasInternalSession session, Object parentObject) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        LookupTable lookupTable = session.head().getLookupTable();
        this.converter.populateTargetField(session, lookupTable, sourceField, parentObject, targetField);
    }

    public void enqueueFieldAndParent(Field field, Object parentObject) {
        this.pathParentQueue.put(field.getPath(), parentObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitWriting(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        try {
            if (targetField instanceof FieldGroup) {
                FieldGroup targetFieldGroup = (FieldGroup)targetField;
                if (targetFieldGroup.getField().size() > 0) {
                    for (Field f : targetFieldGroup.getField()) {
                        session.head().setTargetField(f);
                        this.doCommitWriting(session);
                    }
                } else {
                    AtlasPath path = new AtlasPath(targetField.getPath());
                    if (path.getLastSegment().getCollectionType() != CollectionType.NONE) {
                        this.doCommitWriting(session);
                    }
                }
                return;
            }
            this.doCommitWriting(session);
        }
        finally {
            if (!this.pathParentQueue.isEmpty()) {
                LOG.warn("Discarding uncommitted entry in the queue: {}", this.pathParentQueue);
                this.pathParentQueue.clear();
            }
        }
    }

    private void doCommitWriting(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        AtlasPath path = new AtlasPath(targetField.getPath());
        Object parentObject = this.pathParentQueue.get(targetField.getPath());
        this.pathParentQueue.remove(targetField.getPath());
        this.converter.convertTargetValue(session, parentObject, targetField);
        AtlasPath.SegmentContext lastSegment = path.getLastSegment();
        if (path.isRoot().booleanValue()) {
            if (lastSegment.getCollectionType() == CollectionType.NONE) {
                this.rootObject = targetField.getValue();
            } else {
                Object adjusted = this.writerUtil.adjustCollectionSize(this.rootObject, lastSegment);
                if (adjusted != this.rootObject) {
                    this.rootObject = adjusted;
                }
                this.writerUtil.setCollectionItem(adjusted, targetField.getValue(), lastSegment);
            }
            return;
        }
        if (parentObject == null) {
            return;
        }
        String targetClassName = null;
        if (targetField instanceof JavaField) {
            targetClassName = ((JavaField)targetField).getClassName();
        } else if (targetField instanceof JavaEnumField) {
            targetClassName = ((JavaEnumField)targetField).getClassName();
        }
        if (lastSegment.getCollectionType() == CollectionType.NONE) {
            if (targetField.getFieldType() == FieldType.COMPLEX && !(targetField instanceof JavaEnumField) && targetField.getValue() == null) {
                if (targetClassName != null && !targetClassName.isEmpty()) {
                    this.writerUtil.createComplexChildObject(parentObject, lastSegment, this.writerUtil.loadClass(targetClassName));
                } else {
                    this.writerUtil.createComplexChildObject(parentObject, lastSegment);
                }
            } else {
                this.writerUtil.setChildObject(parentObject, targetField.getValue(), lastSegment);
            }
        } else {
            Object collection = this.writerUtil.getChildObject(parentObject, lastSegment);
            if (collection == null) {
                collection = this.writerUtil.createComplexChildObject(parentObject, lastSegment);
            }
            if (lastSegment.getCollectionIndex() == null) {
                return;
            }
            Object adjusted = this.writerUtil.adjustCollectionSize(collection, lastSegment);
            if (adjusted != collection) {
                this.writerUtil.setChildObject(parentObject, adjusted, lastSegment);
            }
            if (targetField.getFieldType() == FieldType.COMPLEX && targetField.getValue() == null) {
                if (targetClassName != null && !targetClassName.isEmpty()) {
                    this.writerUtil.createComplexChildObject(parentObject, lastSegment, this.writerUtil.loadClass(targetClassName));
                } else {
                    this.writerUtil.createComplexChildObject(parentObject, lastSegment);
                }
            } else {
                this.writerUtil.setCollectionItem(adjusted, targetField.getValue(), lastSegment);
            }
        }
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Object parentObject = this.prepareParentObject(session);
        this.populateTargetFieldValue(session, parentObject);
        Field targetField = session.head().getTargetField();
        this.enqueueFieldAndParent(targetField, parentObject);
        this.commitWriting(session);
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    public void setTargetValueConverter(TargetValueConverter converter) {
        this.converter = converter;
    }

    public void setCollectionItemClass(Class<?> clazz) {
        this.collectionItemClass = clazz;
    }

    private String writeDocumentToString(boolean stripSpaces, Object object) throws AtlasException {
        try {
            if (object == null) {
                return "";
            }
            String result = object.toString();
            if (stripSpaces) {
                result = result.replaceAll("\n|\r", "");
                result = result.replaceAll("> *?<", "><");
            }
            return result;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

