/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.module;

import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.core.validate.MappingFieldPairValidator;
import io.atlasmap.java.module.JavaValidationService;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class JavaMappingFieldPairValidator
extends MappingFieldPairValidator {
    private JavaValidationService service;
    private AtlasConversionService conversionService;

    JavaMappingFieldPairValidator(JavaValidationService service, AtlasConversionService conversion) {
        super((BaseModuleValidationService)service);
        this.service = service;
        this.conversionService = conversion;
    }

    protected void doValidateFieldTypes(List<Validation> validations, String mappingId, Field sourceField, Field targetField, FieldType sourceFieldType) {
        if (sourceField instanceof JavaField && targetField instanceof JavaField && (sourceFieldType == null || targetField.getFieldType() == null || sourceFieldType == FieldType.COMPLEX || targetField.getFieldType() == FieldType.COMPLEX) && ((JavaField)sourceField).getClassName() != null && ((JavaField)targetField).getClassName() != null) {
            this.validateClassConversion(mappingId, (JavaField)sourceField, (JavaField)targetField, validations);
            return;
        }
        if (sourceField.getFieldType() != targetField.getFieldType()) {
            super.doValidateFieldTypes(validations, mappingId, sourceField, targetField, sourceFieldType);
        }
    }

    private void validateClassConversion(String mappingId, JavaField inputField, JavaField outField, List<Validation> validations) {
        if (inputField.getFieldType() == FieldType.COMPLEX) {
            return;
        }
        Optional atlasConverter = this.conversionService.findMatchingConverter(inputField.getClassName(), outField.getClassName());
        if (!atlasConverter.isPresent()) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("Conversion from '%s' to '%s' is required but no converter is available", inputField.getClassName(), outField.getClassName()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        } else {
            Method[] methods = ((AtlasConverter)atlasConverter.get()).getClass().getMethods();
            AtlasConversionInfo conversionInfo = Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).filter(atlasConversionInfo -> atlasConversionInfo != null).filter(atlasConversionInfo -> atlasConversionInfo.sourceType().compareTo((Enum)inputField.getFieldType()) == 0 && atlasConversionInfo.targetType().compareTo((Enum)outField.getFieldType()) == 0).findFirst().orElse(null);
            if (conversionInfo != null) {
                this.populateConversionConcerns(validations, mappingId, conversionInfo, this.service.getModuleFieldName(inputField), this.service.getModuleFieldName(outField));
            }
        }
    }
}

