/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.module;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.java.core.JavaFieldReader;
import io.atlasmap.java.core.JavaFieldWriter;
import io.atlasmap.java.core.JavaFieldWriterUtil;
import io.atlasmap.java.core.TargetValueConverter;
import io.atlasmap.java.module.JavaValidationService;
import io.atlasmap.java.v2.AtlasJavaModelFactory;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.lang.reflect.Array;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="JavaModule", uri="atlas:java", modes={"SOURCE", "TARGET"}, dataFormats={"java"}, configPackages={"io.atlasmap.java.v2"})
public class JavaModule
extends BaseAtlasModule {
    public static final String DEFAULT_LIST_CLASS = "java.util.ArrayList";
    private static final Logger LOG = LoggerFactory.getLogger(JavaModule.class);
    private TargetValueConverter targetValueConverter = null;
    private JavaFieldWriterUtil writerUtil = null;

    public JavaModule() {
        this.setAutomaticallyProcessOutputFieldActions(false);
    }

    public void init() {
        this.writerUtil = new JavaFieldWriterUtil(this.getClassLoader(), this.getConversionService());
        this.targetValueConverter = new TargetValueConverter(this.getClassLoader(), this.getConversionService(), this.writerUtil);
    }

    public void destroy() {
        this.targetValueConverter = null;
        this.writerUtil = null;
    }

    public void processPreValidation(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            LOG.error("Invalid session: Session and AtlasMapping must be specified");
            throw new AtlasValidationException("Invalid session");
        }
        JavaValidationService javaValidator = new JavaValidationService(this.getConversionService(), this.getFieldActionService());
        javaValidator.setMode(this.getMode());
        javaValidator.setDocId(this.getDocId());
        List javaValidations = javaValidator.validateMapping(atlasSession.getMapping());
        atlasSession.getValidations().getValidation().addAll(javaValidations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected " + javaValidations.size() + " java validation notices");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreValidation completed", (Object)this.getDocId());
        }
    }

    public void processPreSourceExecution(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null || atlasSession.getMapping().getMappings() == null || atlasSession.getMapping().getMappings().getMapping() == null) {
            throw new AtlasException("AtlasSession not properly intialized with a mapping that contains field mappings");
        }
        Object sourceDocument = atlasSession.getSourceDocument(this.getDocId());
        if (sourceDocument == null) {
            AtlasUtil.addAudit((AtlasInternalSession)atlasSession, (String)this.getDocId(), (String)String.format("Null source document: docId='%s'", this.getDocId()), (AuditStatus)AuditStatus.WARN, null);
        } else {
            JavaFieldReader reader = new JavaFieldReader();
            reader.setConversionService(this.getConversionService());
            reader.setDocument(sourceDocument);
            atlasSession.setFieldReader(this.getDocId(), (AtlasFieldReader)reader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreSourceExcution completed", (Object)this.getDocId());
        }
    }

    public void processPreTargetExecution(AtlasInternalSession atlasSession) throws AtlasException {
        Object rootObject;
        if (atlasSession == null || atlasSession.getMapping() == null || atlasSession.getMapping().getMappings() == null || atlasSession.getMapping().getMappings().getMapping() == null) {
            throw new AtlasException("AtlasSession not properly intialized with a mapping that contains field mappings");
        }
        String targetClassName = AtlasUtil.unescapeFromUri((String)AtlasUtil.getUriParameterValue((String)this.getUri(), (String)"className"));
        String collectionTypeStr = AtlasUtil.unescapeFromUri((String)AtlasUtil.getUriParameterValue((String)this.getUri(), (String)"collectionType"));
        CollectionType collectionType = collectionTypeStr != null ? CollectionType.fromValue((String)collectionTypeStr) : CollectionType.NONE;
        String collectionClassName = AtlasUtil.unescapeFromUri((String)AtlasUtil.getUriParameterValue((String)this.getUri(), (String)"collectionClassName"));
        JavaFieldWriter writer = new JavaFieldWriter(this.writerUtil);
        Class clazz = this.writerUtil.loadClass(targetClassName);
        if (collectionType == CollectionType.ARRAY) {
            rootObject = Array.newInstance(clazz, 0);
        } else if (collectionType != CollectionType.NONE) {
            rootObject = collectionClassName != null ? this.writerUtil.instantiateObject(this.writerUtil.loadClass(collectionClassName)) : this.writerUtil.instantiateObject(this.writerUtil.getDefaultCollectionImplClass(collectionType));
            writer.setCollectionItemClass(clazz);
        } else {
            rootObject = this.writerUtil.instantiateObject(clazz);
        }
        writer.setRootObject(rootObject);
        writer.setTargetValueConverter(this.targetValueConverter);
        atlasSession.setFieldWriter(this.getDocId(), (AtlasFieldWriter)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreTargetExcution completed", (Object)this.getDocId());
        }
    }

    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        JavaFieldReader reader = (JavaFieldReader)session.getFieldReader(this.getDocId(), JavaFieldReader.class);
        if (reader == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)sourceField, (String)String.format("Source document '%s' doesn't exist", this.getDocId()), (AuditStatus)AuditStatus.ERROR, null);
            return;
        }
        reader.read(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue()});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        AtlasPath path = new AtlasPath(targetField.getPath());
        FieldGroup targetFieldGroup = null;
        if (path.hasCollection() && !path.isIndexedCollection()) {
            targetFieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
            session.head().setTargetField((Field)targetFieldGroup);
        }
        JavaFieldWriter writer = (JavaFieldWriter)session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        if (targetFieldGroup == null) {
            Object parentObject;
            if (sourceField instanceof FieldGroup) {
                List subFields = ((FieldGroup)sourceField).getField();
                if (subFields == null || subFields.size() == 0) {
                    return;
                }
                Integer index = targetField.getIndex();
                if (index != null) {
                    if (subFields.size() <= index) {
                        AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)String.format("The number of source fields (%s) is smaller than target index (%s) - ignoring", subFields.size(), index), (AuditStatus)AuditStatus.WARN, null);
                        return;
                    }
                    sourceField = (Field)subFields.get(index);
                } else {
                    sourceField = (Field)subFields.get(subFields.size() - 1);
                }
                session.head().setSourceField(sourceField);
            }
            if ((parentObject = writer.prepareParentObject(session)) != null) {
                writer.populateTargetFieldValue(session, parentObject);
                writer.enqueueFieldAndParent(targetField, parentObject);
            }
        } else if (!(sourceField instanceof FieldGroup)) {
            JavaEnumField targetSubField = targetField instanceof JavaEnumField ? new JavaEnumField() : new JavaField();
            AtlasJavaModelFactory.copyField((Field)targetField, (Field)targetSubField, (boolean)false);
            path.setVacantCollectionIndex(Integer.valueOf(0));
            targetSubField.setPath(path.toString());
            targetFieldGroup.getField().add(targetSubField);
            session.head().setTargetField((Field)targetSubField);
            Object parentObject = writer.prepareParentObject(session);
            if (parentObject != null) {
                writer.populateTargetFieldValue(session, parentObject);
                writer.enqueueFieldAndParent((Field)targetSubField, parentObject);
            }
            session.head().setTargetField((Field)targetFieldGroup);
        } else {
            Object parentObject;
            if (((FieldGroup)sourceField).getField().size() == 0 && (parentObject = writer.prepareParentObject(session)) != null) {
                writer.enqueueFieldAndParent((Field)targetFieldGroup, parentObject);
            }
            JavaEnumField previousTargetSubField = null;
            for (int i = 0; i < ((FieldGroup)sourceField).getField().size(); ++i) {
                Field sourceSubField = (Field)((FieldGroup)sourceField).getField().get(i);
                JavaEnumField targetSubField = targetField instanceof JavaEnumField ? new JavaEnumField() : new JavaField();
                AtlasJavaModelFactory.copyField((Field)targetField, (Field)targetSubField, (boolean)false);
                this.getCollectionHelper().copyCollectionIndexes(sourceField, sourceSubField, (Field)targetSubField, previousTargetSubField);
                previousTargetSubField = targetSubField;
                targetFieldGroup.getField().add(targetSubField);
                session.head().setSourceField(sourceSubField);
                session.head().setTargetField((Field)targetSubField);
                Object parentObject2 = writer.prepareParentObject(session);
                if (parentObject2 == null) continue;
                writer.populateTargetFieldValue(session, parentObject2);
                writer.enqueueFieldAndParent((Field)targetSubField, parentObject2);
            }
            session.head().setSourceField(sourceField);
            session.head().setTargetField((Field)targetFieldGroup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processTargetFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}], TargetField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue(), targetField.getDocId(), targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
    }

    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        JavaFieldWriter writer = (JavaFieldWriter)session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        writer.commitWriting(session);
    }

    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        session.removeFieldReader(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostSourceExecution completed", (Object)this.getDocId());
        }
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        JavaFieldWriter writer = (JavaFieldWriter)session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        if (writer != null && writer.getRootObject() != null) {
            session.setTargetDocument(this.getDocId(), writer.getRootObject());
        } else {
            AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)String.format("No target document created for DataSource '%s'", this.getDocId()), (AuditStatus)AuditStatus.WARN, null);
        }
        session.removeFieldWriter(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
        }
    }

    public Boolean isSupportedField(Field field) {
        if (super.isSupportedField(field).booleanValue()) {
            return true;
        }
        return field instanceof JavaField || field instanceof JavaEnumField;
    }

    public Field cloneField(Field field) throws AtlasException {
        return AtlasJavaModelFactory.cloneJavaField((Field)field, (boolean)true);
    }
}

