/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.v2;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.atlasmap.v2.Field;
import java.io.Serializable;

@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.CLASS, property="jsonType")
public class JsonField
extends Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Boolean primitive;
    protected String typeName;
    protected Boolean userCreated;

    public Boolean isPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(Boolean value) {
        this.primitive = value;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String value) {
        this.typeName = value;
    }

    public Boolean isUserCreated() {
        return this.userCreated;
    }

    public void setUserCreated(Boolean value) {
        this.userCreated = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JsonField that = (JsonField)object;
        String leftName = this.getName();
        String rightName = that.getName();
        if (this.getName() != null) {
            if (that.getName() == null) return false;
            if (!leftName.equals(rightName)) {
                return false;
            }
        } else if (that.getName() != null) {
            return false;
        }
        Boolean leftPrimitive = this.isPrimitive();
        Boolean rightPrimitive = that.isPrimitive();
        if (this.primitive != null) {
            if (that.primitive == null) return false;
            if (!leftPrimitive.equals(rightPrimitive)) {
                return false;
            }
        } else if (that.primitive != null) {
            return false;
        }
        String leftTypeName = this.getTypeName();
        String rightTypeName = that.getTypeName();
        if (this.typeName != null) {
            if (that.typeName == null) return false;
            if (!leftTypeName.equals(rightTypeName)) {
                return false;
            }
        } else if (that.typeName != null) {
            return false;
        }
        Boolean leftUserCreated = this.isUserCreated();
        Boolean rightUserCreated = that.isUserCreated();
        if (this.userCreated != null) {
            if (that.userCreated == null) return false;
            if (leftUserCreated.equals(rightUserCreated)) return true;
            return false;
        }
        if (that.userCreated == null) return true;
        return false;
    }

    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        String theName = this.getName();
        if (this.getName() != null) {
            currentHashCode += theName.hashCode();
        }
        currentHashCode *= 31;
        Boolean thePrimitive = this.isPrimitive();
        if (this.primitive != null) {
            currentHashCode += thePrimitive.hashCode();
        }
        currentHashCode *= 31;
        String theTypeName = this.getTypeName();
        if (this.typeName != null) {
            currentHashCode += theTypeName.hashCode();
        }
        currentHashCode *= 31;
        Boolean theUserCreated = this.isUserCreated();
        if (this.userCreated != null) {
            currentHashCode += theUserCreated.hashCode();
        }
        return currentHashCode;
    }
}

