/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

final class Append {
    private final Writer writer;
    private int nameIndex;
    private boolean comma;

    Append(Writer writer) {
        this.writer = writer;
    }

    Append append(String content) {
        try {
            this.writer.append(content);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Append eol() {
        try {
            this.writer.append("\n");
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Append append(String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    void resetNextName() {
        this.nameIndex = 0;
        this.comma = false;
    }

    String nextName(String prefix) {
        return prefix + this.nameIndex++;
    }

    void commaAppend(String name) {
        if (!this.comma) {
            this.comma = true;
        } else {
            this.append(", ");
        }
        this.append(name);
    }
}

