/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AspectPair;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class AspectMethod {
    private final List<AspectPair> aspectPairs;
    private final ExecutableElement method;
    private final List<MethodReader.MethodParam> params;
    private final String rawReturn;
    private final String simpleName;
    private final List<? extends TypeMirror> thrownTypes;
    private final String localName;

    AspectMethod(int nameIndex, List<AspectPair> aspectPairs, ExecutableElement method) {
        this.aspectPairs = this.sort(aspectPairs);
        this.method = method;
        this.simpleName = method.getSimpleName().toString();
        this.params = this.initParams(method.getParameters());
        this.rawReturn = method.getReturnType().toString();
        this.thrownTypes = method.getThrownTypes();
        this.localName = this.simpleName + nameIndex;
    }

    private List<AspectPair> sort(List<AspectPair> aspectPairs) {
        Collections.sort(aspectPairs);
        return aspectPairs;
    }

    List<MethodReader.MethodParam> initParams(List<? extends VariableElement> parameters) {
        ArrayList<MethodReader.MethodParam> mps = new ArrayList<MethodReader.MethodParam>(parameters.size());
        for (VariableElement variableElement : parameters) {
            mps.add(new MethodReader.MethodParam(variableElement));
        }
        return mps;
    }

    void addTargets(Set<String> targets) {
        for (AspectPair aspectPair : this.aspectPairs) {
            targets.add(aspectPair.annotationShortName());
        }
    }

    boolean isVoid() {
        return "void".equals(this.rawReturn);
    }

    void addImports(ImportTypeMap importTypes) {
        for (AspectPair aspectPair : this.aspectPairs) {
            aspectPair.addImports(importTypes);
        }
        for (MethodReader.MethodParam methodParam : this.params) {
            methodParam.addImports(importTypes);
        }
        for (TypeMirror typeMirror : this.method.getThrownTypes()) {
            importTypes.add(typeMirror.toString());
        }
    }

    void writeMethod(Append writer) {
        writer.eol().append("  @Override").eol();
        writer.append("  public %s %s(", this.rawReturn, this.simpleName);
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).writeMethodParamAspect(writer);
        }
        writer.append(")");
        this.writeThrowsClause(writer);
        writer.append(" {").eol();
        String type = this.isVoid() ? "Run" : "Call<>";
        writer.append("    var call = new Invocation.%s(() ->", type);
        this.invokeSuper(writer, this.simpleName);
        writer.append(")").eol();
        this.writeArgs(writer);
        writer.append("  }").eol();
    }

    private void writeThrowsClause(Append writer) {
        if (!this.thrownTypes.isEmpty()) {
            writer.append(" throws ");
            for (int i = 0; i < this.thrownTypes.size(); ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                writer.append(Util.shortName(this.thrownTypes.get(i).toString()));
            }
        }
    }

    private void invokeSuper(Append writer, String simpleName) {
        writer.append(" super.%s(", simpleName);
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            writer.append(this.params.get(i).simpleName());
        }
        writer.append(")");
    }

    void writeSetupFields(Append writer) {
        writer.append("  private final Method %s;", this.localName).eol();
        for (AspectPair aspectPair : this.aspectPairs) {
            String sn = aspectPair.annotationShortName();
            writer.append("  private final MethodInterceptor %s%s;", this.localName, sn).eol();
        }
    }

    void writeSetupForMethods(Append writer, String shortName) {
        writer.append("      %s = %s.class.getDeclaredMethod(\"%s\"", this.localName, shortName, this.simpleName);
        for (MethodReader.MethodParam param : this.params) {
            writer.append(", ");
            param.writeMethodParamTypeAspect(writer);
            writer.append(".class");
        }
        writer.append(");").eol();
        for (AspectPair aspect : this.aspectPairs) {
            String name = Util.initLower(aspect.annotationShortName());
            String sn = aspect.annotationShortName();
            writer.append("      %s%s = %s.interceptor(%s, %s.getAnnotation(%s.class));", this.localName, sn, name, this.localName, this.localName, sn).eol();
        }
        writer.eol();
    }

    static String aspectTargetShortName(String target) {
        String type = Util.shortName(target);
        return Util.initLower(type);
    }

    void writeArgs(Append writer) {
        writer.append("      .with(this, %s", this.localName);
        if (!this.params.isEmpty()) {
            writer.append(", ");
            int size = this.params.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                writer.append(this.params.get(i).simpleName());
            }
        }
        writer.append(")");
        int aspectCount = this.aspectPairs.size();
        if (aspectCount < 2) {
            writer.append(";").eol();
        } else {
            writer.eol();
            writer.append("      // wrapping inner nested aspects based on ordering attribute").eol();
            int nesting = aspectCount - 1;
            for (int i = 0; i < nesting; ++i) {
                AspectPair aspect = this.aspectPairs.get(i);
                String sn = aspect.annotationShortName();
                writer.append("      .wrap(%s%s)", this.localName, sn);
                if (i < nesting - 1) {
                    writer.eol();
                    continue;
                }
                writer.append(";").eol();
            }
        }
        writer.append("    try {").eol();
        if (aspectCount > 1) {
            writer.append("      // outer-most aspect").eol();
        }
        AspectPair outerAspect = this.aspectPairs.get(aspectCount - 1);
        String sn = outerAspect.annotationShortName();
        writer.append("      %s%s.invoke(call);", this.localName, sn).eol();
        if (!this.isVoid()) {
            writer.append("      return call.finalResult();").eol();
        }
        writer.append("    } catch (RuntimeException ex) {").eol();
        writer.append("      ex.addSuppressed(new InvocationException(\"%s proxy threw exception\"));", this.simpleName).eol();
        writer.append("      throw ex;").eol();
        this.writeThrowsCatch(writer);
        if (this.thrownTypes.stream().map(Object::toString).noneMatch("java.lang.Throwable"::equals)) {
            writer.append("    } catch (Throwable t) {").eol();
            writer.append("      throw new InvocationException(\"%s proxy threw exception\", t);", this.simpleName).eol();
        }
        writer.append("    }").eol();
    }

    private void writeThrowsCatch(Append writer) {
        ArrayList<? extends TypeMirror> types = new ArrayList<TypeMirror>(this.thrownTypes);
        types.removeIf(ProcessingContext::isUncheckedException);
        if (types.isEmpty()) {
            return;
        }
        writer.append("    } catch (");
        types.stream().map(Object::toString).map(Util::shortName).collect(Collectors.collectingAndThen(Collectors.joining(" | "), writer::append)).append(" e) {").eol();
        writer.append("      e.addSuppressed(new InvocationException(\"%s proxy threw exception\"));", this.simpleName).eol();
        writer.append("      throw e;").eol();
    }
}

