/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class DependencyMetaPrism {
    private final String _type;
    private final String _name;
    private final Boolean _importedComponent;
    private final String _method;
    private final String _providesAspect;
    private final List<String> _provides;
    private final List<String> _dependsOn;
    private final String _autoProvides;
    public static final String PRISM_TYPE = "io.avaje.inject.spi.DependencyMeta";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return DependencyMetaPrism.getInstanceOn(element) != null;
    }

    static DependencyMetaPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = DependencyMetaPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return DependencyMetaPrism.getInstance(mirror);
    }

    static Optional<DependencyMetaPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = DependencyMetaPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return DependencyMetaPrism.getOptional(mirror);
    }

    static DependencyMetaPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new DependencyMetaPrism(mirror);
    }

    static Optional<DependencyMetaPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new DependencyMetaPrism(mirror));
    }

    private DependencyMetaPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._type = this.getValue("type", String.class);
        this._name = this.getValue("name", String.class);
        this._importedComponent = this.getValue("importedComponent", Boolean.class);
        this._method = this.getValue("method", String.class);
        this._providesAspect = this.getValue("providesAspect", String.class);
        this._provides = this.getArrayValues("provides", String.class);
        this._dependsOn = this.getArrayValues("dependsOn", String.class);
        this._autoProvides = this.getValue("autoProvides", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String type() {
        return this._type;
    }

    public String name() {
        return this._name;
    }

    public Boolean importedComponent() {
        return this._importedComponent;
    }

    public String method() {
        return this._method;
    }

    public String providesAspect() {
        return this._providesAspect;
    }

    public List<String> provides() {
        return this._provides;
    }

    public List<String> dependsOn() {
        return this._dependsOn;
    }

    public String autoProvides() {
        return this._autoProvides;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = DependencyMetaPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = DependencyMetaPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : DependencyMetaPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue type() {
            return this.values.get("type");
        }

        AnnotationValue name() {
            return this.values.get("name");
        }

        AnnotationValue importedComponent() {
            return this.values.get("importedComponent");
        }

        AnnotationValue method() {
            return this.values.get("method");
        }

        AnnotationValue providesAspect() {
            return this.values.get("providesAspect");
        }

        AnnotationValue provides() {
            return this.values.get("provides");
        }

        AnnotationValue dependsOn() {
            return this.values.get("dependsOn");
        }

        AnnotationValue autoProvides() {
            return this.values.get("autoProvides");
        }
    }
}

