/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class GeneratedPrism {
    private final String _value;
    public static final String PRISM_TYPE = "io.avaje.inject.spi.Generated";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return GeneratedPrism.getInstanceOn(element) != null;
    }

    static GeneratedPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = GeneratedPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return GeneratedPrism.getInstance(mirror);
    }

    static Optional<GeneratedPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = GeneratedPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return GeneratedPrism.getOptional(mirror);
    }

    static GeneratedPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new GeneratedPrism(mirror);
    }

    static Optional<GeneratedPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new GeneratedPrism(mirror));
    }

    private GeneratedPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getValue("value", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String value() {
        return this._value;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = GeneratedPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

