/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.GenericType;
import java.util.ArrayDeque;
import java.util.Deque;

final class GenericTypeParser {
    private final String raw;
    private StringBuilder buf = new StringBuilder();
    private final Deque<GenericType> stack = new ArrayDeque<GenericType>();

    GenericTypeParser(String raw) {
        this.raw = raw;
        this.stack.push(new GenericType(raw));
    }

    GenericType parse() {
        int len = this.raw.length();
        for (int i = 0; i < len; ++i) {
            this.processChar(this.raw.charAt(i));
        }
        return this.stack.peek();
    }

    private void processChar(char ch) {
        switch (ch) {
            case '<': {
                this.startParam();
                break;
            }
            case '>': {
                this.endParam();
                break;
            }
            case ',': {
                this.nextParam();
                break;
            }
            default: {
                this.buf.append(ch);
            }
        }
    }

    private void nextParam() {
        this.endParam();
        GenericType param = new GenericType();
        this.stack.peek().addParam(param);
        this.stack.push(param);
    }

    private void endParam() {
        String content = this.buf.toString();
        if (!content.isEmpty()) {
            this.stack.peek().setMainType(content);
            this.buf = new StringBuilder();
        }
        this.stack.pop();
    }

    private void startParam() {
        this.stack.peek().setMainType(this.buf.toString());
        this.buf = new StringBuilder();
        GenericType param = new GenericType();
        this.stack.peek().addParam(param);
        this.stack.push(param);
    }
}

