/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AspectImportPrism;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.PrimitiveUtil;
import io.avaje.inject.generator.ScopeInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    public static void init(ProcessingEnvironment processingEnv, Set<String> moduleFileProvided) {
        CTX.set(new Ctx(processingEnv, moduleFileProvided));
    }

    public static void testInit() {
        CTX.set(new Ctx());
    }

    static void logError(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    static void logError(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    static void logWarn(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    static void logDebug(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    static String loadMetaInfServices() {
        List<String> lines = ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module");
        return lines.isEmpty() ? null : lines.get(0);
    }

    static List<String> loadMetaInfCustom() {
        return ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module.Custom");
    }

    private static List<String> loadMetaInf(String fullName) {
        try {
            FileObject fileObject = ProcessingContext.CTX.get().filer.getResource(StandardLocation.CLASS_OUTPUT, "", fullName);
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            ProcessingContext.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessingContext.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }

    static JavaFileObject createWriter(String cls) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, new Element[0]);
    }

    static FileObject createMetaInfWriter(ScopeInfo.Type scopeType) throws IOException {
        String serviceName = scopeType == ScopeInfo.Type.DEFAULT ? "META-INF/services/io.avaje.inject.spi.Module" : "META-INF/services/io.avaje.inject.test.TestModule";
        return ProcessingContext.createMetaInfWriterFor(serviceName);
    }

    private static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return ProcessingContext.CTX.get().filer.createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static TypeElement element(String rawType) {
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(rawType);
    }

    static Types types() {
        return ProcessingContext.CTX.get().typeUtils;
    }

    static TypeElement elementMaybe(String rawType) {
        if (rawType == null) {
            return null;
        }
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(rawType);
    }

    static TypeElement asElement(TypeMirror returnType) {
        String wrapper = PrimitiveUtil.wrap(returnType.toString());
        return wrapper == null ? (TypeElement)ProcessingContext.CTX.get().typeUtils.asElement(returnType) : ProcessingContext.element(wrapper);
    }

    static boolean isUncheckedException(TypeMirror returnType) {
        Types types = ProcessingContext.CTX.get().typeUtils;
        TypeMirror runtime = ProcessingContext.element("java.lang.RuntimeException").asType();
        return types.isSubtype(returnType, runtime);
    }

    static void addModule(String moduleFullName) {
        if (moduleFullName != null) {
            ProcessingContext.CTX.get().uniqueModuleNames.add(moduleFullName);
        }
    }

    static boolean isDuplicateModule(String moduleFullName) {
        return ProcessingContext.CTX.get().uniqueModuleNames.contains(moduleFullName);
    }

    static boolean externallyProvided(String type) {
        return ProcessingContext.CTX.get().providedTypes.contains(type) || ProcessingContext.CTX.get().optionalTypes.contains(type);
    }

    static void addOptionalType(String paramType) {
        if (!ProcessingContext.CTX.get().providedTypes.contains(paramType)) {
            ProcessingContext.CTX.get().optionalTypes.add(paramType);
        }
    }

    static void addImportedAspects(Map<String, AspectImportPrism> importedMap) {
        ProcessingContext.CTX.get().aspectImportPrisms.putAll(importedMap);
    }

    static void addImportedType(String importedMap) {
        ProcessingContext.CTX.get().importedTypes.add(importedMap);
    }

    static boolean isImportedType(String type) {
        return ProcessingContext.CTX.get().importedTypes.contains(type);
    }

    static Optional<AspectImportPrism> getImportedAspect(String type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().aspectImportPrisms.get(type));
    }

    public static void clear() {
        CTX.remove();
    }

    static final class Ctx {
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;
        private final Set<String> uniqueModuleNames = new HashSet<String>();
        private final Set<String> providedTypes = new HashSet<String>();
        private final Set<String> optionalTypes = new LinkedHashSet<String>();
        private final Set<String> importedTypes = new LinkedHashSet<String>();
        private final Map<String, AspectImportPrism> aspectImportPrisms = new HashMap<String, AspectImportPrism>();

        public Ctx(ProcessingEnvironment processingEnv, Set<String> moduleFileProvided) {
            this.messager = processingEnv.getMessager();
            this.filer = processingEnv.getFiler();
            this.elementUtils = processingEnv.getElementUtils();
            this.typeUtils = processingEnv.getTypeUtils();
            ExternalProvider.registerModuleProvidedTypes(this.providedTypes);
            this.providedTypes.addAll(moduleFileProvided);
        }

        public Ctx() {
            this.messager = null;
            this.filer = null;
            this.elementUtils = null;
            this.typeUtils = null;
        }
    }
}

