/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

final class ScopeUtil {
    ScopeUtil() {
    }

    static String initName(String name) {
        return "Inject".equals(name = ScopeUtil.name(name)) ? "DInject" : name;
    }

    static String name(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos > -1) {
            name = name.substring(pos + 1);
        }
        if (name.endsWith("Scope")) {
            name = name.substring(0, name.length() - 5);
        }
        if (name.endsWith("Module")) {
            name = name.substring(0, name.length() - 6);
        }
        return ScopeUtil.camelCase(name);
    }

    private static String camelCase(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean upper = true;
        for (char aChar : name.toCharArray()) {
            if (Character.isLetterOrDigit(aChar)) {
                if (upper) {
                    aChar = Character.toUpperCase(aChar);
                    upper = false;
                }
                sb.append(aChar);
                continue;
            }
            if (!ScopeUtil.toUpperOn(aChar)) continue;
            upper = true;
        }
        return sb.toString();
    }

    private static boolean toUpperOn(char aChar) {
        return aChar == ' ' || aChar == '-' || aChar == '_';
    }
}

