/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanEntry;
import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.Builder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class DBeanScopeProxy
implements BeanScope {
    private Builder builder;
    private BeanScope delegate;

    public DBeanScopeProxy(Builder builder) {
        this.builder = builder;
    }

    void inject(BeanScope delegate) {
        this.delegate = delegate;
        this.builder = null;
    }

    @Override
    public <T> T get(Class<T> type) {
        if (this.delegate != null) {
            return this.delegate.get(type);
        }
        return this.builder.get(type);
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        if (this.delegate != null) {
            return this.delegate.get(type, name);
        }
        return this.builder.get(type, name);
    }

    @Override
    public <T> T get(Type type, String name) {
        if (this.delegate != null) {
            return this.delegate.get(type, name);
        }
        return this.builder.get(type, name);
    }

    @Override
    public <T> Optional<T> getOptional(Class<T> type) {
        if (this.delegate != null) {
            return this.delegate.getOptional(type);
        }
        return this.builder.getOptional(type);
    }

    @Override
    public <T> Optional<T> getOptional(Type type, String name) {
        if (this.delegate != null) {
            return this.delegate.getOptional(type, name);
        }
        return this.builder.getOptional(type, name);
    }

    @Override
    public List<Object> listByAnnotation(Class<? extends Annotation> annotation) {
        if (this.delegate != null) {
            return this.delegate.listByAnnotation(annotation);
        }
        throw new IllegalStateException("Proxy BeanScope can't use listByAnnotation while scope is being built");
    }

    @Override
    public <T> List<T> list(Class<T> type) {
        if (this.delegate != null) {
            return this.delegate.list(type);
        }
        return this.builder.list(type);
    }

    @Override
    public <T> List<T> list(Type type) {
        if (this.delegate != null) {
            return this.delegate.list(type);
        }
        return this.builder.list(type);
    }

    @Override
    public <T> List<T> listByPriority(Class<T> type) {
        if (this.delegate != null) {
            return this.delegate.listByPriority(type);
        }
        throw new IllegalStateException("Proxy BeanScope can't use listByPriority while scope is being built");
    }

    @Override
    public <T> List<T> listByPriority(Class<T> type, Class<? extends Annotation> priority) {
        if (this.delegate != null) {
            return this.delegate.listByPriority(type, priority);
        }
        throw new IllegalStateException("Proxy BeanScope can't use listByPriority while scope is being built");
    }

    @Override
    public <T> Map<String, T> map(Type type) {
        if (this.delegate != null) {
            return this.delegate.map(type);
        }
        return this.builder.map(type);
    }

    @Override
    public List<BeanEntry> all() {
        if (this.delegate != null) {
            return this.delegate.all();
        }
        throw new IllegalStateException("Proxy BeanScope can't use all() while scope is being built");
    }

    @Override
    public boolean contains(Type type) {
        if (this.delegate != null) {
            return this.delegate.contains(type);
        }
        return this.builder.contains(type);
    }

    @Override
    public boolean contains(String type) {
        if (this.delegate != null) {
            return this.delegate.contains(type);
        }
        return this.builder.contains(type);
    }

    @Override
    public void close() {
        if (this.delegate == null) {
            throw new IllegalStateException("Proxy BeanScope can't use close() while scope is being built");
        }
        this.delegate.close();
    }
}

