/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath;

import io.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final Pattern bundleIdPattern = Pattern.compile("^\\d+");

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        TreeSet<String> resourceNames = new TreeSet<String>();
        Bundle bundle = this.targetBundleOrCurrent(FrameworkUtil.getBundle(this.getClass()), locationUrl);
        Enumeration entries = bundle.findEntries(locationUrl.getPath(), "*", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                resourceNames.add(this.pathWithoutLeadingSlash((URL)entries.nextElement()));
            }
        }
        return resourceNames;
    }

    private Bundle targetBundleOrCurrent(Bundle currentBundle, URL locationUrl) {
        try {
            Bundle targetBundle = currentBundle.getBundleContext().getBundle(this.bundleId(locationUrl.getHost()));
            return targetBundle != null ? targetBundle : currentBundle;
        }
        catch (Exception e) {
            return currentBundle;
        }
    }

    private long bundleId(String host) {
        Matcher matcher = bundleIdPattern.matcher(host);
        if (matcher.find()) {
            return Double.valueOf(matcher.group()).longValue();
        }
        throw new IllegalArgumentException("There's no bundleId in passed URL");
    }

    private String pathWithoutLeadingSlash(URL entry) {
        String path = entry.getPath();
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

