/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.cache;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import io.awspring.cloud.autoconfigure.cache.ElastiCacheProperties;
import io.awspring.cloud.autoconfigure.context.ContextCredentialsAutoConfiguration;
import io.awspring.cloud.cache.CacheFactory;
import io.awspring.cloud.cache.config.annotation.ElastiCacheCacheConfigurer;
import io.awspring.cloud.cache.memcached.MemcachedCacheFactory;
import io.awspring.cloud.cache.redis.RedisCacheFactory;
import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.env.stack.ListableStackResourceFactory;
import io.awspring.cloud.core.env.stack.StackResource;
import io.awspring.cloud.core.region.RegionProvider;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextCredentialsAutoConfiguration.class, ContextDefaultConfigurationRegistrar.class})
@ConditionalOnClass(value={AmazonElastiCache.class})
@ConditionalOnProperty(name={"cloud.aws.elasticache.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ElastiCacheProperties.class})
public class ElastiCacheAutoConfiguration {
    private final ElastiCacheProperties properties;
    private final ListableStackResourceFactory stackResourceFactory;
    private final ClientConfiguration clientConfiguration;

    public ElastiCacheAutoConfiguration(ElastiCacheProperties properties, ObjectProvider<ListableStackResourceFactory> stackResourceFactory, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="elastiCacheClientConfiguration") ObjectProvider<ClientConfiguration> elastiCacheClientConfiguration) {
        this.properties = properties;
        this.stackResourceFactory = (ListableStackResourceFactory)stackResourceFactory.getIfAvailable();
        this.clientConfiguration = (ClientConfiguration)elastiCacheClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(value={AmazonElastiCache.class})
    public AmazonWebserviceClientFactoryBean<AmazonElastiCacheClient> amazonElastiCache(ObjectProvider<RegionProvider> regionProvider, ObjectProvider<AWSCredentialsProvider> credentialsProvider) {
        return new AmazonWebserviceClientFactoryBean(AmazonElastiCacheClient.class, (AWSCredentialsProvider)credentialsProvider.getIfAvailable(), (RegionProvider)regionProvider.getIfAvailable(), this.clientConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean(value={CachingConfigurer.class})
    public CachingConfigurer cachingConfigurer(AmazonElastiCache amazonElastiCache, ResourceIdResolver resourceIdResolver, List<CacheFactory> cacheFactories) {
        if (!this.properties.getClusters().isEmpty()) {
            return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.properties.getCacheNames(), cacheFactories);
        }
        return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.getConfiguredCachesInStack(), cacheFactories);
    }

    @Bean
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    public RedisCacheFactory redisCacheFactory() {
        return new RedisCacheFactory(this.properties.getExpiryTimePerCache(), this.properties.getDefaultExpiration());
    }

    @Bean
    @ConditionalOnClass(value={MemcachedClient.class})
    public MemcachedCacheFactory memcachedCacheFactory() {
        return new MemcachedCacheFactory(this.properties.getExpiryTimePerCache(), this.properties.getDefaultExpiration());
    }

    private List<String> getConfiguredCachesInStack() {
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.stackResourceFactory != null) {
            for (StackResource stackResource : this.stackResourceFactory.resourcesByType("AWS::ElastiCache::CacheCluster")) {
                cacheNames.add(stackResource.getLogicalId());
            }
        }
        return cacheNames;
    }
}

