/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.mail;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import io.awspring.cloud.autoconfigure.context.ContextCredentialsAutoConfiguration;
import io.awspring.cloud.autoconfigure.mail.SimpleEmailProperties;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.region.RegionProvider;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.awspring.cloud.mail.simplemail.SimpleEmailServiceJavaMailSender;
import io.awspring.cloud.mail.simplemail.SimpleEmailServiceMailSender;
import java.util.Optional;
import javax.mail.Session;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
@ConditionalOnClass(value={AmazonSimpleEmailService.class, MailSender.class})
@ConditionalOnMissingBean(value={MailSender.class})
@Import(value={ContextCredentialsAutoConfiguration.class})
@EnableConfigurationProperties(value={SimpleEmailProperties.class})
@ConditionalOnProperty(name={"cloud.aws.mail.enabled"}, havingValue="true", matchIfMissing=true)
@Deprecated
public class SimpleEmailAutoConfiguration {
    private final RegionProvider regionProvider;
    private final ClientConfiguration clientConfiguration;

    public SimpleEmailAutoConfiguration(ObjectProvider<RegionProvider> regionProvider, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="sesClientConfiguration") ObjectProvider<ClientConfiguration> sesClientConfiguration, SimpleEmailProperties properties) {
        this.regionProvider = properties.getRegion() == null ? (RegionProvider)regionProvider.getIfAvailable() : new StaticRegionProvider(properties.getRegion());
        this.clientConfiguration = (ClientConfiguration)sesClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonSimpleEmailService.class)
    public AmazonWebserviceClientFactoryBean<AmazonSimpleEmailServiceClient> amazonSimpleEmailService(AWSCredentialsProvider credentialsProvider, SimpleEmailProperties properties) {
        AmazonWebserviceClientFactoryBean clientFactoryBean = new AmazonWebserviceClientFactoryBean(AmazonSimpleEmailServiceClient.class, credentialsProvider, this.regionProvider, this.clientConfiguration);
        Optional.ofNullable(properties.getEndpoint()).ifPresent(arg_0 -> ((AmazonWebserviceClientFactoryBean)clientFactoryBean).setCustomEndpoint(arg_0));
        return clientFactoryBean;
    }

    @Bean
    @ConditionalOnMissingClass(value={"javax.mail.Session"})
    public MailSender simpleMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceMailSender(amazonSimpleEmailService);
    }

    @Bean
    @ConditionalOnClass(value={Session.class})
    public JavaMailSender javaMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceJavaMailSender(amazonSimpleEmailService);
    }
}

