/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.core;

import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.Profile;
import io.awspring.cloud.autoconfigure.core.StsProperties;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={AwsCredentialsProvider.class, ProfileFile.class})
@ConditionalOnMissingBean(value={AwsCredentialsProvider.class})
@EnableConfigurationProperties(value={CredentialsProperties.class})
public class CredentialsProviderAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsProviderAutoConfiguration.class);
    private static final String STS_WEB_IDENTITY_TOKEN_FILE_CREDENTIALS_PROVIDER = "software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider";
    private final CredentialsProperties properties;
    private final AwsRegionProvider regionProvider;

    public CredentialsProviderAutoConfiguration(CredentialsProperties properties, AwsRegionProvider regionProvider) {
        this.properties = properties;
        this.regionProvider = regionProvider;
    }

    @Bean
    public AwsCredentialsProvider credentialsProvider() {
        return CredentialsProviderAutoConfiguration.createCredentialsProvider(this.properties, this.regionProvider);
    }

    public static AwsCredentialsProvider createCredentialsProvider(CredentialsProperties properties, AwsRegionProvider regionProvider) {
        Profile profile;
        ArrayList<Object> providers = new ArrayList<Object>();
        if (StringUtils.hasText((String)properties.getAccessKey()) && StringUtils.hasText((String)properties.getSecretKey())) {
            providers.add(CredentialsProviderAutoConfiguration.createStaticCredentialsProvider(properties));
        }
        if (properties.isInstanceProfile()) {
            providers.add(InstanceProfileCredentialsProvider.create());
        }
        if ((profile = properties.getProfile()) != null && profile.getName() != null) {
            providers.add(CredentialsProviderAutoConfiguration.createProfileCredentialProvider(profile));
        }
        StsProperties sts = properties.getSts();
        if (ClassUtils.isPresent((String)STS_WEB_IDENTITY_TOKEN_FILE_CREDENTIALS_PROVIDER, null)) {
            try {
                providers.add(StsCredentialsProviderFactory.create(sts, regionProvider));
            }
            catch (IllegalStateException e) {
                LOGGER.warn("Skipping creating `StsCredentialsProvider`. `software.amazon.awssdk:sts` is on the classpath, but neither `spring.cloud.aws.credentials.sts` properties are configured nor `AWS_WEB_IDENTITY_TOKEN_FILE` or the javaproperty `aws.webIdentityTokenFile` is set");
            }
        }
        if (providers.isEmpty()) {
            return DefaultCredentialsProvider.create();
        }
        if (providers.size() == 1) {
            return (AwsCredentialsProvider)providers.get(0);
        }
        return AwsCredentialsProviderChain.builder().credentialsProviders(providers).build();
    }

    private static StaticCredentialsProvider createStaticCredentialsProvider(CredentialsProperties properties) {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)properties.getAccessKey(), (String)properties.getSecretKey()));
    }

    private static ProfileCredentialsProvider createProfileCredentialProvider(Profile profile) {
        ProfileFile profileFile = profile.getPath() != null ? ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content(Paths.get(profile.getPath(), new String[0])).build() : ProfileFile.defaultProfileFile();
        return ProfileCredentialsProvider.builder().profileName(profile.getName()).profileFile(profileFile).build();
    }

    private static class StsCredentialsProviderFactory {
        private StsCredentialsProviderFactory() {
        }

        private static AwsCredentialsProvider create(@Nullable StsProperties stsProperties, AwsRegionProvider regionProvider) {
            PropertyMapper propertyMapper = PropertyMapper.get();
            StsWebIdentityTokenFileCredentialsProvider.Builder builder = StsWebIdentityTokenFileCredentialsProvider.builder().stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).region(regionProvider.getRegion())).build());
            if (stsProperties != null) {
                builder.asyncCredentialUpdateEnabled(Boolean.valueOf(stsProperties.isAsyncCredentialsUpdate()));
                propertyMapper.from(stsProperties::getRoleArn).whenNonNull().to(arg_0 -> ((StsWebIdentityTokenFileCredentialsProvider.Builder)builder).roleArn(arg_0));
                propertyMapper.from(stsProperties::getWebIdentityTokenFile).whenNonNull().to(b -> builder.webIdentityTokenFile(Paths.get(b, new String[0])));
                propertyMapper.from(stsProperties::getRoleSessionName).whenNonNull().to(arg_0 -> ((StsWebIdentityTokenFileCredentialsProvider.Builder)builder).roleSessionName(arg_0));
            }
            return builder.build();
        }
    }
}

