/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class BootstrapLoggingHelper {
    private BootstrapLoggingHelper() {
    }

    public static void reconfigureLoggers(DeferredLogFactory logFactory, String ... classes) {
        ArrayList loggers = new ArrayList();
        for (String clazz : classes) {
            if (!ClassUtils.isPresent((String)clazz, null)) continue;
            try {
                loggers.add(Class.forName(clazz));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        loggers.forEach(it -> BootstrapLoggingHelper.reconfigureLogger(it, logFactory));
    }

    private static void reconfigureLogger(Class<?> type, DeferredLogFactory logFactory) {
        ReflectionUtils.doWithFields(type, field -> {
            field.setAccessible(true);
            field.set(null, logFactory.getLog(type));
        }, BootstrapLoggingHelper::isUpdateableLogField);
    }

    private static boolean isUpdateableLogField(Field field) {
        return !Modifier.isFinal(field.getModifiers()) && field.getType().isAssignableFrom(Log.class);
    }
}

